/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.networking.ControllerBlockEntity;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.networktool.NetworkStatusMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends AEBaseEntityBlock<ControllerBlockEntity> {
    public static final EnumProperty<ControllerBlockState> CONTROLLER_STATE = EnumProperty.m_61587_((String)"state", ControllerBlockState.class);
    public static final EnumProperty<ControllerRenderType> CONTROLLER_TYPE = EnumProperty.m_61587_((String)"type", ControllerRenderType.class);

    public ControllerBlock() {
        super(ControllerBlock.defaultProps(Material.f_76279_).m_60978_(6.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(CONTROLLER_STATE, (Comparable)((Object)ControllerBlockState.offline))).m_61124_(CONTROLLER_TYPE, (Comparable)((Object)ControllerRenderType.block)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONTROLLER_STATE});
        builder.m_61104_(new Property[]{CONTROLLER_TYPE});
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getControllerType(this.m_49966_(), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return this.getControllerType(state, level, pos);
    }

    private BlockState getControllerType(BlockState baseState, LevelAccessor level, BlockPos pos) {
        boolean zz;
        int z;
        int y;
        ControllerRenderType type = ControllerRenderType.block;
        int x = pos.m_123341_();
        boolean xx = this.getBlockEntity((BlockGetter)level, x - 1, y = pos.m_123342_(), z = pos.m_123343_()) != null && this.getBlockEntity((BlockGetter)level, x + 1, y, z) != null;
        boolean yy = this.getBlockEntity((BlockGetter)level, x, y - 1, z) != null && this.getBlockEntity((BlockGetter)level, x, y + 1, z) != null;
        boolean bl = zz = this.getBlockEntity((BlockGetter)level, x, y, z - 1) != null && this.getBlockEntity((BlockGetter)level, x, y, z + 1) != null;
        if (xx && !yy && !zz) {
            type = ControllerRenderType.column_x;
        } else if (!xx && yy && !zz) {
            type = ControllerRenderType.column_y;
        } else if (!xx && !yy && zz) {
            type = ControllerRenderType.column_z;
        } else if ((xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) >= 2) {
            int v = (Math.abs(x) + Math.abs(y) + Math.abs(z)) % 2;
            type = v == 0 ? ControllerRenderType.inside_a : ControllerRenderType.inside_b;
        }
        return (BlockState)baseState.m_61124_(CONTROLLER_TYPE, (Comparable)((Object)type));
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        ControllerBlockEntity controller = (ControllerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (controller != null) {
            if (!level.f_46443_) {
                MenuOpener.open(NetworkStatusMenu.CONTROLLER_TYPE, player, MenuLocators.forBlockEntity(controller));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        ControllerBlockEntity tc = (ControllerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (tc != null) {
            tc.updateState();
        }
    }

    public static enum ControllerBlockState implements StringRepresentable
    {
        offline,
        online,
        conflicted;


        public String m_7912_() {
            return this.name();
        }
    }

    public static enum ControllerRenderType implements StringRepresentable
    {
        block,
        column_x,
        column_y,
        column_z,
        inside_a,
        inside_b;


        public String m_7912_() {
            return this.name();
        }
    }
}

