/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.world;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.init.BPItems;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.registries.RegistryObject;

public class WorldGenVolcano
extends Feature<NoneFeatureConfiguration> {
    private static final int MAX_VOLCANO_RADIUS = 200;
    private HashMap<Pos, Integer> volcanoMap;
    private static List<RegistryObject<Block>> alterBlocks = new ArrayList<RegistryObject<Block>>();

    public WorldGenVolcano(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public static void updateAlterBlocks() {
        alterBlocks = new ArrayList<RegistryObject<Block>>();
        alterBlocks.add(BPBlocks.amethyst_block);
        alterBlocks.add(BPBlocks.ruby_block);
        alterBlocks.add(BPBlocks.sapphire_block);
        alterBlocks.add(BPBlocks.green_sapphire_block);
        if (((Boolean)BPConfig.CONFIG.generateTungstenInVolcano.get()).booleanValue()) {
            alterBlocks.add(BPBlocks.tungsten_block);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos blockPos = context.m_159777_();
        int startChunkX = blockPos.m_123341_() >> 8;
        int startChunkZ = blockPos.m_123343_() >> 8;
        this.volcanoMap = new HashMap();
        ((WorldgenRandom)rand).m_64690_(world.m_7328_() + 1L, startChunkX, startChunkZ);
        int volcanoHeight = 140 + rand.m_188503_(40);
        List<Pos>[] distMap = this.calculateDistMap();
        boolean first = true;
        int middleX = (startChunkX << 8) + 128;
        int middleZ = (startChunkZ << 8) + 128;
        for (int dist = 0; dist < distMap.length; ++dist) {
            List<Pos> distList = distMap[dist];
            boolean isFinished = true;
            for (Pos p : distList) {
                int posHeight;
                int n = posHeight = first ? volcanoHeight : this.getNewVolcanoHeight(p, rand, dist);
                if (posHeight > 0) {
                    this.volcanoMap.put(new Pos(p.x, p.z), posHeight);
                    int x = middleX + p.x;
                    int z = middleZ + p.z;
                    if (!first && x >> 4 == blockPos.m_123341_() >> 4 && z >> 4 == blockPos.m_123343_() >> 4) {
                        int i;
                        int worldHeight = world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
                        for (i = posHeight; i > 0 && (i > worldHeight || this.canReplace(world, x, i, z)); --i) {
                            this.m_5974_((LevelWriter)world, new BlockPos(x, i, z), ((Block)BPBlocks.basalt.get()).m_49966_());
                        }
                        for (i = posHeight + 1; i < volcanoHeight; ++i) {
                            if (!this.canReplace(world, x, i, z) || world.m_8055_(new BlockPos(x, i, z)).m_60767_() == Material.f_76305_) continue;
                            this.m_5974_((LevelWriter)world, new BlockPos(x, i, z), Blocks.f_50016_.m_49966_());
                        }
                    }
                    isFinished = false;
                }
                first = false;
            }
            if (isFinished) break;
        }
        if (middleX >> 4 == blockPos.m_123341_() >> 4 && middleZ >> 4 == blockPos.m_123343_() >> 4) {
            this.generateLavaColumn(world, middleX, volcanoHeight, middleZ, rand);
            this.generateLootChamber(world, middleX, rand.m_188503_(volcanoHeight - 80) + 60, middleZ, rand);
        }
        return true;
    }

    private boolean canReplace(WorldGenLevel world, int x, int y, int z) {
        if (world.m_46859_(new BlockPos(x, y, z))) {
            return true;
        }
        Block block = world.m_8055_(new BlockPos(x, y, z)).m_60734_();
        Material material = world.m_8055_(new BlockPos(x, y, z)).m_60767_();
        return material == Material.f_76320_ || material == Material.f_76277_ || material == Material.f_76274_ || material == Material.f_76300_ || material == Material.f_76302_ || block == Blocks.f_49990_;
    }

    private void generateLavaColumn(WorldGenLevel world, int x, int topY, int z, RandomSource rand) {
        if (rand.m_188500_() < (Double)BPConfig.CONFIG.volcanoActiveToInactiveRatio.get()) {
            this.m_5974_((LevelWriter)world, new BlockPos(x, topY, z), ((Block)BPBlocks.cracked_basalt_lava.get()).m_49966_());
        } else {
            this.m_5974_((LevelWriter)world, new BlockPos(x, topY, z), Blocks.f_49991_.m_49966_());
            world.m_186469_(new BlockPos(x, topY, z), Blocks.f_49991_.m_49966_().m_60819_().m_76152_(), 10);
        }
        for (int y = topY - 1; y >= 10; --y) {
            if (world.m_8055_(new BlockPos(x, y, z)) == Blocks.f_50752_.m_49966_()) continue;
            this.m_5974_((LevelWriter)world, new BlockPos(x + 1, y, z), ((Block)BPBlocks.basalt.get()).m_49966_());
            this.m_5974_((LevelWriter)world, new BlockPos(x - 1, y, z), ((Block)BPBlocks.basalt.get()).m_49966_());
            this.m_5974_((LevelWriter)world, new BlockPos(x, y, z + 1), ((Block)BPBlocks.basalt.get()).m_49966_());
            this.m_5974_((LevelWriter)world, new BlockPos(x, y, z - 1), ((Block)BPBlocks.basalt.get()).m_49966_());
            this.m_5974_((LevelWriter)world, new BlockPos(x, y, z), Blocks.f_49991_.m_49966_());
        }
    }

    private List<Pos>[] calculateDistMap() {
        List[] distMap = new List[200];
        for (int x = -200; x <= 200; ++x) {
            for (int z = -200; z <= 200; ++z) {
                int dist = (int)Math.sqrt(x * x + z * z);
                if (dist >= 200) continue;
                ArrayList<Pos> distList = distMap[dist];
                if (distList == null) {
                    distMap[dist] = distList = new ArrayList<Pos>();
                }
                distList.add(new Pos(x, z));
            }
        }
        return distMap;
    }

    private int getNewVolcanoHeight(Pos requestedPos, RandomSource rand, int distFromCenter) {
        int neighborCount = 0;
        int totalHeight = 0;
        for (int x = requestedPos.x - 1; x <= requestedPos.x + 1; ++x) {
            for (int z = requestedPos.z - 1; z <= requestedPos.z + 1; ++z) {
                Integer neighborHeight = this.volcanoMap.get(new Pos(x, z));
                if (neighborHeight == null) continue;
                ++neighborCount;
                totalHeight += neighborHeight.intValue();
            }
        }
        if (neighborCount != 0) {
            double avgHeight = (double)totalHeight / (double)neighborCount;
            if (rand.m_188503_(5) != 0) {
                return (int)avgHeight - 2;
            }
            int blocksDown = distFromCenter < 2 ? 0 : (distFromCenter == 2 ? rand.m_188503_(2) : (int)(Math.pow(avgHeight - 60.0 + 1.0, 1.2) * 0.005 + (rand.m_188500_() - 0.5) * 3.0 + 0.4));
            if (blocksDown < 0) {
                blocksDown = 0;
            }
            return (int)avgHeight - blocksDown;
        }
        return -1;
    }

    private void generateLootChamber(WorldGenLevel world, int middleX, int startY, int middleZ, RandomSource rand) {
        int roomSize = 9;
        int roomHeight = 5;
        int startX = middleX - roomSize / 2;
        int startZ = middleZ - roomSize / 2;
        for (int x = startX; x < startX + roomSize; ++x) {
            for (int y = startY; y < startY + roomHeight; ++y) {
                for (int z = startZ; z < startZ + roomSize; ++z) {
                    int xOffset = Math.abs(x - middleX);
                    int zOffset = Math.abs(z - middleZ);
                    if (xOffset == 0 && zOffset == 0) continue;
                    boolean spawnGlass = xOffset <= 1 && zOffset <= 1;
                    this.m_5974_((LevelWriter)world, new BlockPos(x, y, z), spawnGlass ? ((Block)BPBlocks.reinforced_sapphire_glass.get()).m_49966_() : Blocks.f_50016_.m_49966_());
                }
            }
        }
        for (Direction d : Direction.values()) {
            if (d == Direction.UP || d == Direction.DOWN || rand.m_188503_(2) != 0) continue;
            this.generateAltar(world, middleX + d.m_122429_() * roomSize / 2, startY - 1, middleZ + d.m_122431_() * roomSize / 2, rand, d);
        }
    }

    private void generateAltar(WorldGenLevel world, int startX, int startY, int startZ, RandomSource rand, Direction dir) {
        this.generateLootChest(world, new BlockPos(startX, startY + 1, startZ), rand, dir);
        Direction opDir = dir.m_122424_();
        Block altarBlock = (Block)alterBlocks.get(new Random().nextInt(alterBlocks.size())).get();
        this.setAltarBlockAndPossiblyTrap(world, startX, startY, startZ, rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + opDir.m_122429_(), startY, startZ + opDir.m_122431_(), rand, altarBlock);
        Direction sideDir = Direction.DOWN;
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.m_122429_(), startY, startZ + sideDir.m_122431_(), rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.m_122429_() + opDir.m_122429_(), startY, startZ + sideDir.m_122431_() + opDir.m_122431_(), rand, altarBlock);
        sideDir = sideDir.m_122424_();
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.m_122429_(), startY, startZ + sideDir.m_122431_(), rand, altarBlock);
        this.setAltarBlockAndPossiblyTrap(world, startX + sideDir.m_122429_() + opDir.m_122429_(), startY, startZ + sideDir.m_122431_() + opDir.m_122431_(), rand, altarBlock);
    }

    private void setAltarBlockAndPossiblyTrap(WorldGenLevel world, int x, int y, int z, RandomSource rand, Block altarBlock) {
        this.m_5974_((LevelWriter)world, new BlockPos(x, y, z), altarBlock.m_49966_());
        if (rand.m_188503_(6) == 0) {
            this.m_5974_((LevelWriter)world, new BlockPos(x, y - 1, z), Blocks.f_50077_.m_49966_());
            this.m_5974_((LevelWriter)world, new BlockPos(x, y - 2, z), Blocks.f_50330_.m_49966_());
        }
    }

    private void generateLootChest(WorldGenLevel world, BlockPos pos, RandomSource rand, Direction dir) {
        this.m_5974_((LevelWriter)world, pos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)dir.m_122424_()));
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ChestBlockEntity) {
            if (rand.m_188503_(5) == 0 && ((Boolean)BPConfig.CONFIG.generateTungstenInVolcano.get()).booleanValue()) {
                ((ChestBlockEntity)te).m_6836_(13, new ItemStack((ItemLike)BPItems.tungsten_ingot.get(), 5 + rand.m_188503_(10)));
            } else {
                ((ChestBlockEntity)te).m_59626_(BuiltInLootTables.f_78742_, (long)rand.m_188502_());
            }
        }
    }

    private static class Pos {
        public final int x;
        public final int z;

        public Pos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object object) {
            if (object instanceof Pos) {
                Pos pos = (Pos)object;
                return pos.x == this.x && pos.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return (this.x << 13) + this.z;
        }
    }
}

