/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileThermopile
extends TileMachineBase {
    private final int MAX_VOLTAGE = 100;
    private final BlutricityStorage storage = new BlutricityStorage(100.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileThermopile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.THERMOPILE.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return super.getCapability(cap);
    }

    public static void tickThermopile(Level level, BlockPos pos, BlockState state, TileThermopile tileThermopile) {
        if (!level.f_46443_) {
            tileThermopile.storage.resetCurrent();
            if (level.m_8055_(pos.m_121945_(Direction.DOWN)).m_60734_() == Blocks.f_49991_ && tileThermopile.storage.getEnergy() < (double)tileThermopile.MAX_VOLTAGE) {
                tileThermopile.storage.addEnergy(0.1, false);
            }
            for (Direction facing : Direction.values()) {
                BlockEntity tile = level.m_7702_(pos.m_121945_(facing));
                if (tile == null || !tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.m_122424_()).isPresent()) continue;
                IPowerBase exStorage = (IPowerBase)tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.m_122424_()).orElse(null);
                EnergyHelper.balancePower(exStorage, tileThermopile.storage);
            }
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundTag tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.m_128441_("energy")) {
            Tag nbtstorage = tCompound.m_128423_("energy");
            CapabilityBlutricity.readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundTag tCompound) {
        super.writeToPacketNBT(tCompound);
        Tag nbtstorage = CapabilityBlutricity.writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null);
        tCompound.m_128365_("energy", nbtstorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }
}

