/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.block.power.BlockBlulectricFurnace;
import com.bluepowermod.container.ContainerBlulectricFurnace;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileBlulectricFurnace
extends TileMachineBase
implements WorldlyContainer,
MenuProvider {
    private final BlutricityStorage storage = new BlutricityStorage(1000.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;
    private boolean isActive;
    private int currentProcessTime;
    public static final int SLOTS = 2;
    private ItemStack inventory;
    private ItemStack outputInventory;
    private SmeltingRecipe currentRecipe;
    private boolean updatingRecipe = true;
    protected final ContainerData fields = new ContainerData(){

        public int m_6413_(int i) {
            switch (i) {
                case 0: {
                    return (int)TileBlulectricFurnace.this.storage.getEnergy();
                }
                case 1: {
                    return TileBlulectricFurnace.this.currentProcessTime;
                }
                case 2: {
                    return (int)TileBlulectricFurnace.this.storage.getMaxEnergy();
                }
            }
            return 0;
        }

        public void m_8050_(int i, int value) {
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    TileBlulectricFurnace.this.currentProcessTime = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public TileBlulectricFurnace(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.BLULECTRIC_FURNACE.get(), pos, state);
        this.inventory = ItemStack.f_41583_;
        this.outputInventory = ItemStack.f_41583_;
    }

    public static void tickFurnace(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        TileBlulectricFurnace tileFurnace = (TileBlulectricFurnace)blockEntity;
        if (level != null && !level.f_46443_) {
            tileFurnace.storage.resetCurrent();
            for (Direction facing : Direction.values()) {
                BlockEntity tile = level.m_7702_(pos.m_121945_(facing));
                if (tile == null) continue;
                tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.m_122424_()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, tileFurnace.storage));
            }
            if (tileFurnace.updatingRecipe) {
                if (level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)tileFurnace, level).isPresent()) {
                    tileFurnace.currentRecipe = (SmeltingRecipe)level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)tileFurnace, level).get();
                    if (!(tileFurnace.outputInventory.m_41720_() == tileFurnace.currentRecipe.m_8043_().m_41720_() && tileFurnace.outputInventory.m_41613_() + tileFurnace.currentRecipe.m_5874_((Container)tileFurnace).m_41613_() <= tileFurnace.outputInventory.m_41741_() || tileFurnace.outputInventory.m_41619_())) {
                        tileFurnace.currentRecipe = null;
                    }
                } else {
                    tileFurnace.currentRecipe = null;
                }
                tileFurnace.updatingRecipe = false;
            }
            if (tileFurnace.currentRecipe != null) {
                if (tileFurnace.storage.getEnergy() / tileFurnace.storage.getMaxEnergy() > 0.5) {
                    int n;
                    tileFurnace.storage.addEnergy(-1.0, false);
                    tileFurnace.setIsActive(true);
                    ++tileFurnace.currentProcessTime;
                    if ((double)n >= 100.0 / (tileFurnace.storage.getEnergy() / tileFurnace.storage.getMaxEnergy())) {
                        tileFurnace.currentProcessTime = 0;
                        if (!tileFurnace.outputInventory.m_41619_()) {
                            tileFurnace.outputInventory.m_41764_(tileFurnace.outputInventory.m_41613_() + tileFurnace.currentRecipe.m_5874_((Container)tileFurnace).m_41613_());
                        } else {
                            tileFurnace.outputInventory = tileFurnace.currentRecipe.m_5874_((Container)tileFurnace).m_41777_();
                        }
                        tileFurnace.m_7407_(0, 1);
                        tileFurnace.updatingRecipe = true;
                    }
                } else {
                    tileFurnace.setIsActive(false);
                }
            } else {
                tileFurnace.currentProcessTime = 0;
                tileFurnace.setIsActive(false);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }

    @Override
    public void m_142466_(CompoundTag tCompound) {
        super.m_142466_(tCompound);
        CompoundTag tc = tCompound.m_128469_("inventory");
        this.inventory = ItemStack.m_41712_((CompoundTag)tc);
        this.outputInventory = ItemStack.m_41712_((CompoundTag)tCompound.m_128469_("outputInventory"));
    }

    @Override
    protected void m_183515_(CompoundTag tCompound) {
        super.m_183515_(tCompound);
        CompoundTag tc = new CompoundTag();
        this.inventory.m_41739_(tc);
        tCompound.m_128365_("inventory", (Tag)tc);
        if (this.outputInventory != null) {
            CompoundTag outputCompound = new CompoundTag();
            this.outputInventory.m_41739_(outputCompound);
            tCompound.m_128365_("outputInventory", (Tag)outputCompound);
        }
    }

    @Override
    public void readFromPacketNBT(CompoundTag tag) {
        super.readFromPacketNBT(tag);
        this.isActive = tag.m_128471_("isActive");
        this.currentProcessTime = tag.m_128451_("currentProcessTime");
        this.markForRenderUpdate();
        if (tag.m_128441_("energy")) {
            Tag nbtstorage = tag.m_128423_("energy");
            CapabilityBlutricity.readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null, nbtstorage);
        }
    }

    @Override
    public void writeToPacketNBT(CompoundTag tag) {
        super.writeToPacketNBT(tag);
        tag.m_128405_("currentProcessTime", this.currentProcessTime);
        tag.m_128379_("isActive", this.isActive);
        Tag nbtstorage = CapabilityBlutricity.writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null);
        tag.m_128365_("energy", nbtstorage);
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    private void setIsActive(boolean _isActive) {
        if (this.f_58857_ != null && _isActive != this.isActive && this.f_58857_.m_46467_() % 4L == 0L) {
            this.isActive = _isActive;
            BlockBlulectricFurnace.setState(this.isActive, this.f_58857_, this.f_58858_);
            this.sendUpdatePacket();
        }
    }

    public int m_6643_() {
        return 2;
    }

    public ItemStack m_8020_(int var1) {
        this.updatingRecipe = true;
        if (var1 == 0) {
            return this.inventory;
        }
        if (var1 == 1) {
            return this.outputInventory;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int index) {
        return this.m_8020_(index);
    }

    public void m_6836_(int var1, ItemStack itemStack) {
        if (var1 == 0) {
            this.inventory = itemStack;
        } else {
            this.outputInventory = itemStack;
        }
        this.updatingRecipe = true;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return player.m_20183_().m_123314_((Vec3i)this.f_58858_, 64.0);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        return slot == 0;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        if (!this.outputInventory.m_41619_()) {
            drops.add((Object)this.outputInventory);
        }
        if (!this.inventory.m_41619_()) {
            drops.add((Object)this.inventory);
        }
        return drops;
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    public boolean m_7155_(int slot, ItemStack item, Direction direction) {
        return this.m_7013_(slot, item);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return slot == 1;
    }

    public boolean m_7983_() {
        return this.inventory.m_41619_();
    }

    public void m_6211_() {
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"blulectric_furnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerBlulectricFurnace(id, inventory, (Container)this, this.fields);
    }
}

