/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.block.power.BlockBlulectricCable;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileMachineBase;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileBlulectricCable
extends TileMachineBase {
    private final BlutricityStorage storage = new BlutricityStorage(100.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileBlulectricCable(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.BLULECTRIC_CABLE.get(), pos, state);
    }

    public static void tickCable(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof TileBlulectricCable) {
            TileBlulectricCable tileCable = (TileBlulectricCable)blockEntity;
            tileCable.storage.resetCurrent();
            if (level != null && !level.f_46443_ && state.m_60734_() instanceof BlockBlulectricCable) {
                ArrayList<Direction> directions = new ArrayList<Direction>(BlockBlulectricCable.FACING.m_6908_());
                directions.removeIf(d -> !tileCable.getCapability((Capability)CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Direction)d).isPresent());
                for (Direction facing : directions) {
                    BlockEntity tile;
                    Block fBlock = level.m_8055_(pos.m_121945_(facing)).m_60734_();
                    if (fBlock != Blocks.f_50016_ && fBlock != Blocks.f_49990_) {
                        tile = level.m_7702_(pos.m_121945_(facing));
                        if (tile == null) continue;
                        tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.m_122424_()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, tileCable.storage));
                        continue;
                    }
                    tile = level.m_7702_(pos.m_121945_(facing).m_121945_(((Direction)state.m_61143_((Property)BlockBlulectricCable.FACING)).m_122424_()));
                    if (tile == null) continue;
                    tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Direction)state.m_61143_((Property)BlockBlulectricCable.FACING)).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, tileCable.storage));
                }
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockState state;
        ArrayList<Direction> directions = new ArrayList<Direction>(BlockBlulectricCable.FACING.m_6908_());
        if (this.f_58857_ != null && (state = this.m_58900_()).m_60734_() instanceof BlockBlulectricCable) {
            directions.remove(state.m_61143_((Property)BlockBlulectricCable.FACING));
            directions.removeIf(d -> this.f_58857_.m_8055_(this.f_58858_.m_121945_(d)).m_60734_() instanceof BlockBlulectricCable && this.f_58857_.m_8055_(this.f_58858_.m_121945_(d)).m_61143_((Property)BlockBlulectricCable.FACING) != state.m_61143_((Property)BlockBlulectricCable.FACING));
        }
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY && (side == null || directions.contains(side))) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundTag tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.m_128441_("energy")) {
            Tag nbtstorage = tCompound.m_128423_("energy");
            CapabilityBlutricity.readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundTag tCompound) {
        super.writeToPacketNBT(tCompound);
        Tag nbtstorage = CapabilityBlutricity.writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null);
        tCompound.m_128365_("energy", nbtstorage);
    }
}

