/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.block.power.BlockBattery;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileBattery
extends TileMachineBase {
    private final int MAX_ENERGY = 3200;
    private final BlutricityStorage storage = new BlutricityStorage(3200.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileBattery(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.BATTERY.get(), pos, state);
    }

    public static void tickBattery(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (!level.f_46443_ && blockEntity instanceof TileBattery) {
            TileBattery tileBattery = (TileBattery)blockEntity;
            tileBattery.storage.resetCurrent();
            for (Direction facing : Direction.values()) {
                BlockEntity tile = level.m_7702_(pos.m_121945_(facing));
                if (tile == null) continue;
                tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.m_122424_()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, tileBattery.storage));
            }
            double energy = tileBattery.storage.getEnergy();
            int batteryLevel = (int)(energy / (double)tileBattery.MAX_ENERGY * 6.0);
            if ((Integer)state.m_61143_((Property)BlockBattery.LEVEL) != batteryLevel) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockBattery.LEVEL, (Comparable)Integer.valueOf(batteryLevel)));
                tileBattery.markForRenderUpdate();
                tileBattery.m_6596_();
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundTag tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.m_128441_("energy")) {
            Tag nbtstorage = tCompound.m_128423_("energy");
            CapabilityBlutricity.readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundTag tCompound) {
        super.writeToPacketNBT(tCompound);
        Tag nbtstorage = CapabilityBlutricity.writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null);
        tCompound.m_128365_("energy", nbtstorage);
    }
}

