/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.ContainerRegulator;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileBase;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileRegulator
extends TileMachineBase
implements WorldlyContainer,
IGuiButtonSensitive,
MenuProvider {
    public static final int SLOTS = 27;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    public IPneumaticTube.TubeColor color = IPneumaticTube.TubeColor.NONE;
    public int mode;
    public int fuzzySetting;

    public TileRegulator(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.REGULATOR.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"regulator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player playerEntity) {
        return new ContainerRegulator(id, inventory, (Container)this);
    }

    public static void tickRegulator(Level level, BlockPos pos, BlockState state, TileRegulator tileRegulator) {
        TileBase.tickTileBase(level, pos, state, tileRegulator);
        if (!level.f_46443_) {
            boolean shouldEmitRedstone;
            Container inv;
            boolean ratiosMatch = true;
            for (int i = 0; i < 9; ++i) {
                if (((ItemStack)tileRegulator.inventory.get(i)).m_41619_()) continue;
                int inputFilterItems = tileRegulator.getItemsInSection((ItemStack)tileRegulator.inventory.get(i), EnumSection.INPUT_FILTER);
                int bufferItems = tileRegulator.getItemsInSection((ItemStack)tileRegulator.inventory.get(i), EnumSection.BUFFER);
                if (bufferItems >= inputFilterItems) continue;
                ratiosMatch = false;
                break;
            }
            if (ratiosMatch && !tileRegulator.isEjecting()) {
                tileRegulator.checkIndividualOutputFilterAndEject();
            }
            if (tileRegulator.mode == 1 && !tileRegulator.isEjecting() && (inv = IOHelper.getInventoryForTE(tileRegulator.getTileCache(tileRegulator.getOutputDirection()))) != null) {
                int i;
                int[] accessibleSlots;
                if (inv instanceof WorldlyContainer) {
                    accessibleSlots = ((WorldlyContainer)inv).m_7071_(tileRegulator.getFacingDirection());
                } else {
                    accessibleSlots = new int[inv.m_6643_()];
                    for (i = 0; i < accessibleSlots.length; ++i) {
                        accessibleSlots[i] = i;
                    }
                }
                for (i = 18; i < 27; ++i) {
                    ItemStack remainder;
                    if (((ItemStack)tileRegulator.inventory.get(i)).m_41619_()) continue;
                    int outputFilterItems = tileRegulator.getItemsInSection((ItemStack)tileRegulator.inventory.get(i), EnumSection.OUTPUT_FILTER);
                    int supplyingInvCount = 0;
                    for (int slot : accessibleSlots) {
                        ItemStack stackInSlot = inv.m_8020_(slot);
                        if (stackInSlot.m_41619_() || !ItemStackHelper.areStacksEqual(stackInSlot, (ItemStack)tileRegulator.inventory.get(i), tileRegulator.fuzzySetting) || !IOHelper.canPlaceItemThroughFaceToInventory(inv, (ItemStack)tileRegulator.inventory.get(i), slot, tileRegulator.getFacingDirection().ordinal())) continue;
                        supplyingInvCount += stackInSlot.m_41613_();
                    }
                    if (supplyingInvCount >= outputFilterItems) continue;
                    ItemStack requestedStack = ((ItemStack)tileRegulator.inventory.get(i)).m_41777_();
                    requestedStack.m_41764_(outputFilterItems - supplyingInvCount);
                    ItemStack bufferItems = IOHelper.extract(tileRegulator, null, requestedStack, true, false, tileRegulator.fuzzySetting);
                    if (bufferItems.m_41619_() || (remainder = IOHelper.insert(inv, bufferItems, tileRegulator.getFacingDirection().ordinal(), false)).m_41619_()) continue;
                    IOHelper.insert(tileRegulator, remainder, null, false);
                }
            }
            boolean bl = shouldEmitRedstone = tileRegulator.isSatisfied() || tileRegulator.animationTicker >= 0;
            if (tileRegulator.isEjecting() != shouldEmitRedstone) {
                tileRegulator.setOutputtingRedstone(shouldEmitRedstone);
                tileRegulator.sendUpdatePacket();
            }
        }
    }

    @Override
    public void onButtonPress(Player player, int messageId, int value) {
        if (messageId == 1) {
            this.mode = value;
        } else if (messageId == 0) {
            this.color = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 2) {
            this.fuzzySetting = value;
        }
    }

    @Override
    public boolean isEjecting() {
        return super.isEjecting() || this.getOutputtingRedstone() > 0;
    }

    private boolean isSatisfied() {
        Container inv = IOHelper.getInventoryForTE(this.getTileCache(this.getOutputDirection()));
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof WorldlyContainer) {
                accessibleSlots = ((WorldlyContainer)inv).m_7071_(this.getFacingDirection());
            } else {
                accessibleSlots = new int[inv.m_6643_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            boolean everythingNull = true;
            for (int i = 18; i < 27; ++i) {
                if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
                everythingNull = false;
                int outputFilterItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.OUTPUT_FILTER);
                int supplyingInvCount = 0;
                for (int slot : accessibleSlots) {
                    ItemStack stackInSlot = inv.m_8020_(slot);
                    if (stackInSlot.m_41619_() || !ItemStackHelper.areStacksEqual(stackInSlot, (ItemStack)this.inventory.get(i), this.fuzzySetting) || !IOHelper.canPlaceItemThroughFaceToInventory(inv, (ItemStack)this.inventory.get(i), slot, this.getFacingDirection().ordinal())) continue;
                    supplyingInvCount += stackInSlot.m_41613_();
                }
                if (supplyingInvCount >= outputFilterItems) continue;
                return false;
            }
            return !everythingNull;
        }
        return false;
    }

    private void checkIndividualOutputFilterAndEject() {
        for (int i = 0; i < 9; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            int inputFilterItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.INPUT_FILTER);
            int bufferItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.BUFFER);
            if (bufferItems < inputFilterItems) continue;
            ItemStack stackFromBuffer = IOHelper.extract(this, null, (ItemStack)this.inventory.get(i), true, false, this.fuzzySetting);
            this.addItemToOutputBuffer(stackFromBuffer, this.color);
        }
    }

    private int getItemsInSection(ItemStack type, EnumSection section) {
        int count = 0;
        for (int i = section.ordinal() * 9; i < section.ordinal() * 9 + 9; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_() || !ItemStackHelper.areStacksEqual(type, (ItemStack)this.inventory.get(i), this.fuzzySetting)) continue;
            count += ((ItemStack)this.inventory.get(i)).m_41613_();
        }
        return count;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (int i = 9; i < 18; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            drops.add((Object)((ItemStack)this.inventory.get(i)));
        }
        return drops;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("filterColor", (byte)this.color.ordinal());
        tag.m_128344_("mode", (byte)this.mode);
        tag.m_128344_("fuzzySetting", (byte)this.fuzzySetting);
        ListTag tagList = new ListTag();
        for (int currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
            CompoundTag tagCompound = new CompoundTag();
            tagCompound.m_128344_("Slot", (byte)currentIndex);
            ((ItemStack)this.inventory.get(currentIndex)).m_41739_(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.m_128365_("Items", (Tag)tagList);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.color = IPneumaticTube.TubeColor.values()[tag.m_128445_("filterColor")];
        this.mode = tag.m_128445_("mode");
        this.fuzzySetting = tag.m_128445_("fuzzySetting");
        ListTag tagList = tag.m_128437_("Items", 10);
        this.inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tagCompound = tagList.m_128728_(i);
            byte slot = tagCompound.m_128445_("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)ItemStack.m_41712_((CompoundTag)tagCompound));
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int i) {
        ItemStack itemStack = this.m_8020_(i);
        if (!itemStack.m_41619_()) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
        return itemStack;
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        return true;
    }

    public int[] m_7071_(Direction side) {
        if (side == this.getFacingDirection() || side == this.getOutputDirection()) {
            return new int[0];
        }
        int[] slots = new int[9];
        for (int i = 9; i < 18; ++i) {
            slots[i - 9] = i;
        }
        return slots;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean m_7983_() {
        return this.inventory.size() == 0;
    }

    public void m_6211_() {
    }

    private static enum EnumSection {
        INPUT_FILTER,
        BUFFER,
        OUTPUT_FILTER;

    }
}

