/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.init.BPBlockEntityType;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileBPMicroblock
extends BlockEntity {
    public static final ModelProperty<Pair<Block, Integer>> PROPERTY_INFO = new ModelProperty();
    private Block block = Blocks.f_50069_;
    private Integer rotation = 0;

    public TileBPMicroblock(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.MICROBLOCK.get(), pos, state);
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(PROPERTY_INFO, (Object)new ImmutablePair((Object)this.block, (Object)this.rotation)).build();
    }

    public void setBlock(Block block) {
        this.block = block;
        this.requestModelDataUpdate();
        this.markDirtyClient();
    }

    public Block getBlock() {
        return this.block;
    }

    private void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)this.block).toString());
        compound.m_128405_("rotation", this.rotation.intValue());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("block")) {
            this.block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.m_128461_("block")));
            this.rotation = compound.m_128451_("rotation");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection networkManager, ClientboundBlockEntityDataPacket packet) {
        Block oldblock = this.getBlock();
        CompoundTag tagCompound = packet.m_131708_();
        super.onDataPacket(networkManager, packet);
        this.m_142466_(tagCompound);
        if (this.f_58857_.f_46443_ && !this.getBlock().equals(oldblock)) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
    }
}

