/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.recipe;

import com.bluepowermod.block.BlockBPMicroblock;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPRecipeSerializer;
import com.bluepowermod.item.ItemSaw;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class MicroblockRecipe
extends CustomRecipe {
    public MicroblockRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int blockCount = 0;
        int saw = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof BlockItem && (Block.m_49814_((Item)stack.m_41720_()) instanceof BlockBPMicroblock || !(Block.m_49814_((Item)stack.m_41720_()) instanceof EntityBlock))) {
                VoxelShape shape = null;
                try {
                    shape = Block.m_49814_((Item)stack.m_41720_()).m_49966_().m_60808_(null, null);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (shape != Shapes.m_83144_() && Block.m_49814_((Item)stack.m_41720_()) != BPBlocks.half_block.get() && Block.m_49814_((Item)stack.m_41720_()) != BPBlocks.panel.get()) continue;
                ++blockCount;
                continue;
            }
            if (stack.m_41720_() instanceof ItemSaw) {
                ++saw;
                continue;
            }
            return false;
        }
        return blockCount == 1 && saw == 1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) continue;
            if (Block.m_49814_((Item)stack.m_41720_()).m_49966_().m_60808_(null, null) == Shapes.m_83144_()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("block", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
                ItemStack outStack = new ItemStack((ItemLike)BPBlocks.half_block.get(), 2);
                outStack.m_41751_(nbt);
                outStack.m_41714_((Component)Component.m_237115_((String)stack.m_41720_().m_5524_()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)((Block)BPBlocks.half_block.get()).m_7705_())));
                return outStack;
            }
            if (Block.m_49814_((Item)stack.m_41720_()) == BPBlocks.half_block.get()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("block", stack.m_41783_().m_128461_("block"));
                ItemStack outStack = new ItemStack((ItemLike)BPBlocks.panel.get(), 2);
                outStack.m_41751_(nbt);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("block")));
                outStack.m_41714_((Component)Component.m_237115_((String)block.m_7705_()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)((Block)BPBlocks.panel.get()).m_7705_())));
                return outStack;
            }
            if (Block.m_49814_((Item)stack.m_41720_()) != BPBlocks.panel.get()) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("block", stack.m_41783_().m_128461_("block"));
            ItemStack outStack = new ItemStack((ItemLike)BPBlocks.cover.get(), 2);
            outStack.m_41751_(nbt);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("block")));
            outStack.m_41714_((Component)Component.m_237115_((String)block.m_7705_()).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)((Block)BPBlocks.cover.get()).m_7705_())));
            return outStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BPRecipeSerializer.MICROBLOCK.get();
    }

    public static class Serializer
    implements RecipeSerializer<MicroblockRecipe> {
        public MicroblockRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new MicroblockRecipe(recipeId);
        }

        public MicroblockRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new MicroblockRecipe(recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, MicroblockRecipe recipe) {
        }
    }
}

