/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.client.gui.IGuiButtonSensitive;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageGuiUpdate {
    private int messageId;
    private int value;

    public MessageGuiUpdate(int messageId, int value) {
        this.messageId = messageId;
        this.value = value;
    }

    public static MessageGuiUpdate decode(FriendlyByteBuf buffer) {
        byte id = buffer.readByte();
        byte value = buffer.readByte();
        return new MessageGuiUpdate(id, value);
    }

    public static void encode(MessageGuiUpdate message, FriendlyByteBuf buffer) {
        buffer.writeByte(message.messageId);
        buffer.writeByte(message.value);
    }

    public static void handle(MessageGuiUpdate msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu container = player.f_36096_;
            if (container instanceof IGuiButtonSensitive) {
                ((IGuiButtonSensitive)container).onButtonPress((Player)player, msg.messageId, msg.value);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

