/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.event;

import com.bluepowermod.ClientProxy;
import com.bluepowermod.block.BlockBPMultipart;
import com.bluepowermod.client.gui.GuiCircuitDatabaseSharing;
import com.bluepowermod.container.ContainerSeedBag;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.item.ItemSeedBag;
import com.bluepowermod.item.ItemSickle;
import com.bluepowermod.util.MultipartUtils;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemStackHandler;

public class BPEventHandler {
    private boolean isAttacking = false;

    @SubscribeEvent
    public void tick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.m_46467_() % 200L == 0L) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onAnvilEvent(AnvilUpdateEvent event) {
        if (!event.getLeft().m_41619_() && event.getLeft().m_41720_() == BPItems.screwdriver.get() && !event.getRight().m_41619_() && event.getRight().m_41720_() == Items.f_42690_ && EnchantmentHelper.m_44831_((ItemStack)event.getRight()).get(Enchantments.f_44985_) != null) {
            event.setOutput(new ItemStack((ItemLike)BPItems.silky_screwdriver.get(), 1));
            event.setCost(20);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldItem;
        if (event.getEntity().m_7500_() && !(heldItem = event.getEntity().m_21120_(event.getHand())).m_41619_() && heldItem.m_41720_() instanceof ItemSickle) {
            heldItem.m_41720_().m_6813_(heldItem, event.getLevel(), event.getLevel().m_8055_(event.getPos()), event.getPos(), (LivingEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public void itemPickUp(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack pickUp = event.getItem().m_32055_();
        if (!(player.f_36096_ instanceof ContainerSeedBag)) {
            for (ItemStack is : player.m_150109_().f_35974_) {
                ItemStack seedType;
                if (is.m_41619_() || !(is.m_41720_() instanceof ItemSeedBag) || (seedType = ItemSeedBag.getSeedType(is)).m_41619_() || !seedType.m_41656_(pickUp)) continue;
                ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
                if (is.m_41782_()) {
                    seedBagInvHandler.deserializeNBT(is.m_41783_().m_128469_("inv"));
                }
                for (int j = 0; j < 9 && !pickUp.m_41619_(); ++j) {
                    pickUp = seedBagInvHandler.insertItem(j, pickUp, false);
                }
                if (!is.m_41782_()) {
                    is.m_41751_(new CompoundTag());
                }
                if (is.m_41783_() != null) {
                    is.m_41783_().m_128365_("inv", (Tag)seedBagInvHandler.serializeNBT());
                }
                if (pickUp.m_41619_()) {
                    event.setResult(Event.Result.ALLOW);
                    event.getItem().m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                event.getItem().m_32045_(pickUp);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        Player killer;
        EntityDamageSource entitySource;
        Entity entity;
        DamageSource damageSource;
        if (!this.isAttacking && (damageSource = event.getSource()) instanceof EntityDamageSource && (entity = (entitySource = (EntityDamageSource)damageSource).m_7639_()) instanceof Player && !(killer = (Player)entity).m_150109_().m_36056_().m_41619_() && EnchantmentHelper.m_44831_((ItemStack)killer.m_150109_().m_36056_()).containsKey(BPEnchantments.disjunction) && (event.getEntity() instanceof EnderMan || event.getEntity() instanceof EnderDragon)) {
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BPEnchantments.disjunction.get()), (ItemStack)killer.m_150109_().m_36056_());
            this.isAttacking = true;
            event.getEntity().m_6469_((DamageSource)entitySource, event.getAmount() * ((float)level * 0.5f + 1.0f));
            this.isAttacking = false;
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Player killer;
        EntityDamageSource entitySource;
        if (event.getSource() instanceof EntityDamageSource && (entitySource = (EntityDamageSource)event.getSource()).m_7639_() instanceof Player && !(killer = (Player)entitySource.m_7639_()).m_150109_().m_36056_().m_41619_() && EnchantmentHelper.m_44831_((ItemStack)killer.m_150109_().m_36056_()).containsKey(BPEnchantments.vorpal)) {
            int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BPEnchantments.vorpal.get()), (ItemStack)killer.m_150109_().m_36056_());
            if (level == 1) {
                if (killer.f_19853_.f_46441_.m_188503_(6) == 1) {
                    this.dropHeads(event);
                }
            } else if (level == 2 && killer.f_19853_.f_46441_.m_188503_(3) == 1) {
                this.dropHeads(event);
            }
        }
    }

    private void dropHeads(LivingDeathEvent event) {
        if (event.getEntity() instanceof Creeper) {
            event.getEntity().m_5552_(new ItemStack((ItemLike)Items.f_42682_, 1), 0.0f);
        }
        if (event.getEntity() instanceof Player) {
            ItemStack drop = new ItemStack((ItemLike)Items.f_42680_, 1);
            drop.m_41751_(new CompoundTag());
            drop.m_41783_().m_128359_("SkullOwner", event.getEntity().m_5446_().getString());
            event.getEntity().m_5552_(drop, 0.0f);
        }
        if (event.getEntity() instanceof AbstractSkeleton) {
            AbstractSkeleton sk = (AbstractSkeleton)event.getEntity();
            if (sk instanceof Skeleton) {
                event.getEntity().m_5552_(new ItemStack((ItemLike)Items.f_42678_, 1), 0.0f);
            } else {
                event.getEntity().m_5552_(new ItemStack((ItemLike)Items.f_42679_, 1), 0.0f);
            }
        }
        if (event.getEntity() instanceof Zombie) {
            event.getEntity().m_5552_(new ItemStack((ItemLike)Items.f_42681_, 1), 0.0f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().m_41782_() && event.getItemStack().m_41783_().m_128441_("tileData") && !event.getItemStack().m_41783_().m_128471_("hideSilkyTooltip")) {
            event.getToolTip().add(Component.m_237113_((String)"gui.tooltip.hasSilkyData"));
        }
        if (ClientProxy.getOpenedGui() instanceof GuiCircuitDatabaseSharing) {
            ItemStack deletingStack = ((GuiCircuitDatabaseSharing)ClientProxy.getOpenedGui()).getCurrentDeletingTemplate();
            if (!deletingStack.m_41619_() && deletingStack == event.getItemStack()) {
                event.getToolTip().add(Component.m_237113_((String)"gui.circuitDatabase.info.sneakClickToConfirmDeleting"));
            } else {
                event.getToolTip().add(Component.m_237113_((String)"gui.circuitDatabase.info.sneakClickToDelete"));
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.getCrafting().m_41720_();
        if (item == Item.m_41439_((Block)Blocks.f_50016_)) {
            return;
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        if (!event.getLevel().f_46443_ && event.getBlock().m_60734_() instanceof GrassBlock) {
            for (int x = event.getPos().m_123341_() - 2; x < event.getPos().m_123341_() + 3; ++x) {
                for (int z = event.getPos().m_123343_() - 2; z < event.getPos().m_123343_() + 3; ++z) {
                    if (!event.getLevel().m_46859_(new BlockPos(x, event.getPos().m_123342_() + 1, z)) || event.getLevel().f_46441_.m_188503_(50) != 1 || !((BushBlock)BPBlocks.indigo_flower.get()).canSustainPlant(event.getLevel().m_8055_(event.getPos().m_7494_()), (BlockGetter)event.getLevel(), event.getPos().m_7494_(), Direction.UP, (IPlantable)BPBlocks.indigo_flower.get())) continue;
                    event.getLevel().m_7731_(event.getPos().m_7494_(), ((BushBlock)BPBlocks.indigo_flower.get()).m_49966_(), 0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void blockHighlightEvent(RenderHighlightEvent event) {
        BlockPos pos;
        BlockState state;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.f_19853_;
        HitResult mop = event.getTarget();
        if (mop instanceof BlockHitResult && (state = world.m_8055_(pos = ((BlockHitResult)mop).m_82425_())).m_60734_() instanceof BlockBPMultipart) {
            BlockState partstate = MultipartUtils.getClosestState((Entity)player, pos);
            VertexConsumer builder = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
            if (partstate != null) {
                VoxelShape shape = partstate.m_60651_((BlockGetter)world, pos, CollisionContext.m_82750_((Entity)player));
                Vec3 projectedView = event.getCamera().m_90583_();
                double d0 = (double)pos.m_123341_() - projectedView.m_7096_();
                double d1 = (double)pos.m_123342_() - projectedView.m_7098_();
                double d2 = (double)pos.m_123343_() - projectedView.m_7094_();
                Matrix4f matrix4f = event.getPoseStack().m_85850_().m_85861_();
                event.setCanceled(true);
            }
        }
    }
}

