/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.compat.jei;

import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.client.gui.BPMenuType;
import com.bluepowermod.client.gui.GuiAlloyFurnace;
import com.bluepowermod.client.gui.GuiBlulectricAlloyFurnace;
import com.bluepowermod.client.gui.GuiBlulectricFurnace;
import com.bluepowermod.compat.jei.AlloyFurnaceHandler;
import com.bluepowermod.container.ContainerAlloyFurnace;
import com.bluepowermod.container.ContainerBlulectricAlloyFurnace;
import com.bluepowermod.container.ContainerBlulectricFurnace;
import com.bluepowermod.container.ContainerProjectTable;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPRecipeTypes;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    Map<Class, IRecipeCategory> categories = new LinkedHashMap<Class, IRecipeCategory>();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("bluepower", "jeiplugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.categories.put(AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe.class, new AlloyFurnaceHandler(guiHelper));
        registry.addRecipeCategories(this.categories.values().toArray(new IRecipeCategory[this.categories.size()]));
    }

    public void registerRecipes(IRecipeRegistration registryIn) {
        registryIn.addRecipes(AlloyFurnaceHandler.RECIPE_TYPE, Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)BPRecipeTypes.ALLOY_SMELTING.get()).stream().filter(r -> !r.m_8043_().m_41619_()).toList());
        registryIn.addRecipes(RecipeTypes.CRAFTING, JEIPlugin.getMicroblockRecipes());
        registryIn.addRecipes(AlloyFurnaceHandler.RECIPE_TYPE, JEIPlugin.getRecyclingRecipes());
    }

    private static List<CraftingRecipe> getMicroblockRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Block block : ForgeRegistries.BLOCKS.getValues().stream().filter(b -> !(b instanceof EntityBlock)).collect(Collectors.toList())) {
            VoxelShape shape = null;
            try {
                shape = block.m_49966_().m_60808_(null, null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (ForgeRegistries.BLOCKS.getKey((Object)block) == null || shape != Shapes.m_83144_()) continue;
            ItemStack output = ItemStack.f_41583_;
            for (RegistryObject<Block> mb : BPBlocks.microblocks) {
                NonNullList input = NonNullList.m_122779_();
                input.add((Object)Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("bluepower:saw"))));
                if (mb == BPBlocks.half_block) {
                    input.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)block)}));
                } else {
                    input.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{output}));
                }
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
                ItemStack stack = new ItemStack((ItemLike)mb.get());
                stack.m_41751_(nbt);
                stack.m_41714_((Component)Component.m_237115_((String)block.m_7705_()).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)((Block)mb.get()).m_7705_())));
                output = stack;
                recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("bluepower:" + ((Block)mb.get()).m_7705_() + block.m_7705_()), "", output, input));
            }
        }
        return recipes;
    }

    private static List<IAlloyFurnaceRecipe> getRecyclingRecipes() {
        ArrayList<IAlloyFurnaceRecipe> recipesList = new ArrayList<IAlloyFurnaceRecipe>();
        for (Map.Entry<Item, ItemStack> recipe : AlloyFurnaceRegistry.getInstance().recyclingRecipes.entrySet()) {
            recipesList.add(new AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe(new ResourceLocation("bluepower:" + ForgeRegistries.ITEMS.getKey((Object)recipe.getValue().m_41720_()).toString().replace(":", ".") + ForgeRegistries.ITEMS.getKey((Object)recipe.getKey()).toString().replace(":", ".")), "", recipe.getValue(), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)recipe.getKey()}), (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)recipe.getKey()})}), (NonNullList<Integer>)NonNullList.m_122783_((Object)0, (Object[])new Integer[]{1})));
        }
        return recipesList;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiAlloyFurnace.class, 100, 32, 28, 23, new RecipeType[]{AlloyFurnaceHandler.RECIPE_TYPE});
        registration.addRecipeClickArea(GuiBlulectricAlloyFurnace.class, 102, 32, 28, 23, new RecipeType[]{AlloyFurnaceHandler.RECIPE_TYPE});
        registration.addRecipeClickArea(GuiBlulectricFurnace.class, 89, 32, 28, 23, new RecipeType[]{RecipeTypes.SMELTING});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BPBlocks.alloyfurnace.get()), new RecipeType[]{AlloyFurnaceHandler.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BPBlocks.blulectric_alloyfurnace.get()), new RecipeType[]{AlloyFurnaceHandler.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BPBlocks.project_table.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BPBlocks.blulectric_furnace.get()), new RecipeType[]{RecipeTypes.SMELTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ContainerAlloyFurnace.class, (MenuType)BPMenuType.ALLOY_FURNACE.get(), AlloyFurnaceHandler.RECIPE_TYPE, 2, 9, 11, 36);
        registration.addRecipeTransferHandler(ContainerBlulectricAlloyFurnace.class, (MenuType)BPMenuType.BLULECTRIC_ALLOY_FURNACE.get(), AlloyFurnaceHandler.RECIPE_TYPE, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(ContainerProjectTable.class, (MenuType)BPMenuType.PROJECT_TABLE.get(), RecipeTypes.CRAFTING, 1, 9, 10, 54);
        registration.addRecipeTransferHandler(ContainerBlulectricFurnace.class, (MenuType)BPMenuType.BLULECTRIC_FURNACE.get(), RecipeTypes.SMELTING, 0, 1, 2, 36);
    }
}

