/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.BlockBPMicroblock;
import com.bluepowermod.block.BlockBPMultipart;
import com.bluepowermod.block.gates.BlockGateBase;
import com.bluepowermod.block.lighting.BlockLampSurface;
import com.bluepowermod.block.power.BlockBattery;
import com.bluepowermod.block.worldgen.BlockBPGlass;
import com.bluepowermod.client.render.BPBlockColor;
import com.bluepowermod.client.render.BPItemColor;
import com.bluepowermod.client.render.BPMicroblockModel;
import com.bluepowermod.client.render.BPMultipartModel;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.client.render.IBPColoredItem;
import com.bluepowermod.client.render.ICustomModelBlock;
import com.bluepowermod.client.render.RenderEngine;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPItems;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class Renderers {
    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional evt) {
        for (Block block : BPBlocks.blockList) {
            if (!(block instanceof ICustomModelBlock)) continue;
            Renderers.registerBakedModel(block);
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelEvent.BakingCompleted event) {
        BPMultipartModel multipartModel = new BPMultipartModel();
        BPMicroblockModel microblockModel = new BPMicroblockModel();
        HashMap<ResourceLocation, BakedModel> models = new HashMap<ResourceLocation, BakedModel>(event.getModels());
        models.forEach((key, model) -> {
            if (key.toString().contains("bluepower:cover") || key.toString().contains("bluepower:panel") || key.toString().contains("bluepower:half_block")) {
                if (((ModelResourceLocation)key).m_119448_().contains("waterlogged=true")) {
                    event.getModels().put(new ModelResourceLocation(key.m_135827_(), key.m_135815_(), ((ModelResourceLocation)key).m_119448_().replace("facing", "face").split(",")[0]), model);
                }
                event.getModels().put(key, microblockModel);
            }
            if (key.toString().contains("bluepower:multipart")) {
                event.getModels().put(key, multipartModel);
            }
        });
        event.getModels().put(new ModelResourceLocation("bluepower:half_block", "inventory"), microblockModel);
        event.getModels().put(new ModelResourceLocation("bluepower:panel", "inventory"), microblockModel);
        event.getModels().put(new ModelResourceLocation("bluepower:cover", "inventory"), microblockModel);
    }

    public static void init() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BPBlockEntityType.LAMP.get()), context -> new RenderLamp());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BPBlockEntityType.ENGINE.get()), context -> new RenderEngine());
        for (RegistryObject item : BPItems.ITEMS.getEntries()) {
            if (!(item.get() instanceof IBPColoredItem)) continue;
            Minecraft.m_91087_().getItemColors().m_92689_((ItemColor)new BPItemColor(), new ItemLike[]{(ItemLike)item.get()});
        }
        for (Block block : BPBlocks.blockList) {
            if (block instanceof IBPColoredBlock) {
                Minecraft.m_91087_().m_91298_().m_92589_((BlockColor)new BPBlockColor(), new Block[]{block});
                Minecraft.m_91087_().getItemColors().m_92689_((ItemColor)new BPBlockColor(), new ItemLike[]{Item.m_41439_((Block)block)});
            }
            if (block instanceof BlockLampSurface || block instanceof BlockGateBase || block instanceof BlockBattery) {
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_());
            }
            if (!(block instanceof BlockBPGlass) && !(block instanceof BlockBPMicroblock) && !(block instanceof BlockBPMultipart)) continue;
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110466_());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BPBlocks.blulectric_cable.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BPBlocks.indigo_flower.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BPBlocks.flax_crop.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BPBlocks.cracked_basalt_lava.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BPBlocks.cracked_basalt_decorative.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BPBlocks.tube.get()), (RenderType)RenderType.m_110463_());
    }

    public static void registerBakedModel(Block block) {
        ((ICustomModelBlock)block).initModel();
    }
}

