/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.BlockBPMicroblock;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.TileBPMicroblock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BPMicroblockModel
implements BakedModel {
    private RegistryObject<Block> defBlock = BPBlocks.marble;
    private RegistryObject<Block> defSize = BPBlocks.half_block;

    BPMicroblockModel() {
    }

    private BPMicroblockModel(RegistryObject<Block> defBlock, RegistryObject<Block> defSize) {
        this.defBlock = defBlock;
        this.defSize = defSize;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        Pair info = (Pair)extraData.get(TileBPMicroblock.PROPERTY_INFO);
        if (info != null) {
            BakedModel typeModel = Minecraft.m_91087_().m_91289_().m_110910_(((Block)info.getKey()).m_49966_());
            BakedModel sizeModel = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(this.defSize.getId(), "face=" + Direction.WEST));
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
            if (state != null && state.m_60734_() instanceof BlockBPMicroblock) {
                sizeModel = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()), "face=" + state.m_61143_((Property)BlockBPMicroblock.FACING)));
            }
            List sizeModelQuads = sizeModel.m_213637_(state, side, rand);
            if (state != null) {
                TextureAtlasSprite sprite = typeModel.m_6160_();
                for (BakedQuad quad : sizeModelQuads) {
                    List typeModelQuads = typeModel.m_213637_(((Block)info.getKey()).m_49966_(), quad.m_111306_(), rand);
                    if (typeModelQuads.size() > 0) {
                        sprite = ((BakedQuad)typeModelQuads.get(0)).m_173410_();
                    }
                    bakedQuads.add(BPMicroblockModel.transform(quad, sprite, (Direction)state.m_61143_((Property)BlockBPMicroblock.FACING), (Block)this.defBlock.get()));
                }
                return bakedQuads;
            }
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        ArrayList<BakedQuad> outquads = new ArrayList<BakedQuad>();
        BakedModel typeModel = Minecraft.m_91087_().m_91289_().m_110910_(((Block)this.defBlock.get()).m_49966_());
        BakedModel sizeModel = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(this.defSize.getId(), "face=" + Direction.WEST));
        if (state != null && state.m_60734_() instanceof BlockBPMicroblock) {
            sizeModel = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()), "face=" + state.m_61143_((Property)BlockBPMicroblock.FACING)));
        }
        List sizeModelQuads = sizeModel.m_213637_(state, side, rand);
        TextureAtlasSprite sprite = typeModel.m_6160_();
        for (BakedQuad quad : sizeModelQuads) {
            List typeModelQuads = typeModel.getQuads(((Block)this.defBlock.get()).m_49966_(), quad.m_111306_(), rand, ModelData.EMPTY, RenderType.m_110463_());
            if (typeModelQuads.size() > 0) {
                sprite = ((BakedQuad)typeModelQuads.get(0)).m_173410_();
            }
            outquads.add(BPMicroblockModel.transform(quad, sprite, Direction.EAST, (Block)this.defBlock.get()));
        }
        return outquads;
    }

    private static BakedQuad transform(final BakedQuad sizeQuad, final TextureAtlasSprite sprite, Direction dir, final Block block) {
        BakedQuad[] finalQuad = new BakedQuad[1];
        QuadBakingVertexConsumer consumer = new QuadBakingVertexConsumer(q -> {
            finalQuad[0] = q;
        }){

            public VertexConsumer m_7421_(float x, float y) {
                float u = (x - sizeQuad.m_173410_().m_118409_()) / (sizeQuad.m_173410_().m_118410_() - sizeQuad.m_173410_().m_118409_()) * 16.0f;
                float v = (y - sizeQuad.m_173410_().m_118411_()) / (sizeQuad.m_173410_().m_118412_() - sizeQuad.m_173410_().m_118411_()) * 16.0f;
                return super.m_7421_(sprite.m_118367_((double)u), sprite.m_118393_((double)v));
            }

            public VertexConsumer m_193479_(int pColorARGB) {
                int color;
                try {
                    color = Minecraft.m_91087_().m_91298_().m_92577_(block.m_49966_(), null, null, sizeQuad.m_111305_());
                }
                catch (Exception ex) {
                    try {
                        color = Minecraft.m_91087_().m_91298_().m_92577_(block.m_49966_(), null, BlockPos.f_121853_, sizeQuad.m_111305_());
                    }
                    catch (Exception ex2) {
                        color = 0;
                    }
                }
                int redMask = 0xFF0000;
                int greenMask = 65280;
                int blueMask = 255;
                int r = (color & redMask) >> 16;
                int g = (color & greenMask) >> 8;
                int b = color & blueMask;
                return this.m_6122_(r / 255, g / 255, b / 255, 1);
            }
        };
        consumer.putBulkData(new PoseStack().m_85850_(), sizeQuad, 1.0f, 1.0f, 1.0f, 1.0f, 0, OverlayTexture.f_118083_, true);
        return finalQuad[0];
    }

    public BakedModel applyTransform(ItemTransforms.TransformType type, PoseStack stack, boolean applyLeftHandTransform) {
        BakedModel sizeModel = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(this.defSize.getId(), "face=" + Direction.WEST));
        sizeModel.m_7442_().m_111808_(type).m_111763_(applyLeftHandTransform, stack);
        return this;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        BakedModel typeModel = Minecraft.m_91087_().m_91289_().m_110910_(((Block)this.defBlock.get()).m_49966_());
        return typeModel.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        Pair info = (Pair)data.get(TileBPMicroblock.PROPERTY_INFO);
        if (info != null) {
            return Minecraft.m_91087_().m_91289_().m_110910_(((Block)info.getKey()).m_49966_()).m_6160_();
        }
        return this.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return new BakedMicroblockOverrideHandler();
    }

    private static final class BakedMicroblockOverrideHandler
    extends ItemOverrides {
        private BakedMicroblockOverrideHandler() {
        }

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int par1) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null && nbt.m_128441_("block")) {
                RegistryObject block = RegistryObject.create((ResourceLocation)new ResourceLocation(nbt.m_128461_("block")), (IForgeRegistry)ForgeRegistries.BLOCKS);
                return new BPMicroblockModel((RegistryObject<Block>)block, (RegistryObject<Block>)RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Block.m_49814_((Item)stack.m_41720_())), (IForgeRegistry)ForgeRegistries.BLOCKS));
            }
            return new BPMicroblockModel((RegistryObject<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("minecraft:stone"), (IForgeRegistry)ForgeRegistries.BLOCKS), (RegistryObject<Block>)RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)Block.m_49814_((Item)stack.m_41720_())), (IForgeRegistry)ForgeRegistries.BLOCKS));
        }
    }
}

