/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui.widget;

import com.bluepowermod.client.gui.widget.BaseWidget;
import com.bluepowermod.client.gui.widget.IGuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiWidget;
import com.bluepowermod.client.gui.widget.IWidgetListener;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;

public class GuiAnimatedStat
extends BaseWidget
implements IGuiAnimatedStat,
IGuiWidget {
    private IGuiAnimatedStat affectingStat;
    private ItemStack iStack;
    private String texture = "";
    private final Screen gui;
    private final List<String> textList = new ArrayList<String>();
    private int baseX;
    private int baseY;
    private int affectedY;
    private int width;
    private int height;
    private int oldBaseX;
    private int oldAffectedY;
    private int oldWidth;
    private int oldHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private final int backGroundColor;
    private String title;
    private boolean leftSided;
    private boolean doneExpanding;
    private ItemRenderer itemRenderer;
    private float textSize;
    private float textScale = 1.0f;
    public static final int MAX_CHAR = 28;
    public static final int ANIMATED_STAT_SPEED = 10;
    private ResourceLocation iconResLoc;
    private IWidgetListener listener;

    public GuiAnimatedStat(Screen gui, String title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        super(-1, xPos, yPos, yPos, backGroundColor, new String[0]);
        Window sr;
        this.gui = gui;
        this.baseX = xPos;
        this.baseY = yPos;
        this.affectingStat = affectingStat;
        this.width = this.minWidth;
        this.height = this.minHeight;
        this.backGroundColor = backGroundColor;
        this.setTitle(title);
        this.texture = "";
        this.leftSided = leftSided;
        this.textSize = gui != null ? ((sr = Minecraft.m_91087_().m_91268_()).m_85445_() < 520 ? (float)(sr.m_85445_() - 220) * 0.0033f : 1.0f) : 1.0f;
        this.affectedY = this.baseY;
        if (affectingStat != null) {
            this.affectedY += affectingStat.getAffectedY() + affectingStat.getHeight();
        }
    }

    public GuiAnimatedStat(Screen gui, int backgroundColor) {
        this(gui, "", 0, 0, backgroundColor, null, false);
    }

    public GuiAnimatedStat(Screen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.iStack = icon;
    }

    public GuiAnimatedStat(Screen gui, int backgroundColor, String texture) {
        this(gui, backgroundColor);
        this.texture = texture;
    }

    public GuiAnimatedStat(Screen gui, String title, ItemStack icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.iStack = icon;
    }

    public GuiAnimatedStat(Screen gui, String title, String texture, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.texture = texture;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.affectingStat = stat;
    }

    @Override
    public Rectangle getButtonScaledRectangle(int origX, int origY, int width, int height) {
        int scaledX = (int)((float)(origX - this.baseX - (this.leftSided ? width : 0)) * this.textSize);
        int scaledY = (int)((float)(origY - this.affectedY) * this.textSize);
        return new Rectangle(scaledX + this.baseX + (this.leftSided ? (int)((float)width * this.textSize) : 0), scaledY + this.affectedY, (int)((float)width * this.textSize), (int)((float)height * this.textSize));
    }

    @Override
    public void scaleTextSize(float scale) {
        this.textSize *= scale;
        this.textScale = scale;
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public IGuiAnimatedStat setText(List<String> text) {
        this.textList.clear();
        for (String line : text) {
            this.textList.addAll(Arrays.asList(WordUtils.wrap((String)I18n.m_118938_((String)line, (Object[])new Object[0]), (int)((int)(28.0f / this.textScale))).split(System.getProperty("line.separator"))));
        }
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(String text) {
        this.textList.clear();
        this.textList.addAll(Arrays.asList(WordUtils.wrap((String)I18n.m_118938_((String)text, (Object[])new Object[0]), (int)((int)(28.0f / this.textScale))).split(System.getProperty("line.separator"))));
        return this;
    }

    @Override
    public void setTextWithoutCuttingString(List<String> text) {
        this.textList.clear();
        this.textList.addAll(text);
    }

    @Override
    public void setMinDimensionsAndReset(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.width = minWidth;
        this.height = minHeight;
    }

    @Override
    public void update() {
        this.oldBaseX = this.baseX;
        this.oldAffectedY = this.affectedY;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        this.doneExpanding = true;
        if (this.isClicked) {
            int maxWidth = this.getMaxWidth(fontRenderer);
            int maxHeight = this.getMaxHeight(fontRenderer);
            for (int i = 0; i < 10; ++i) {
                if (this.width < maxWidth) {
                    ++this.width;
                    this.doneExpanding = false;
                }
                if (this.height < maxHeight) {
                    ++this.height;
                    this.doneExpanding = false;
                }
                if (this.width > maxWidth) {
                    --this.width;
                }
                if (this.height <= maxHeight) continue;
                --this.height;
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                if (this.width > this.minWidth) {
                    --this.width;
                }
                if (this.height <= this.minHeight) continue;
                --this.height;
            }
            this.doneExpanding = false;
        }
        this.affectedY = this.baseY;
        if (this.affectingStat != null) {
            this.affectedY += this.affectingStat.getAffectedY() + this.affectingStat.getHeight();
        }
    }

    protected int getMaxWidth(Font fontRenderer) {
        int maxWidth = fontRenderer.m_92895_(this.title);
        for (String line : this.textList) {
            if (fontRenderer.m_92895_(line) <= maxWidth) continue;
            maxWidth = fontRenderer.m_92895_(line);
        }
        maxWidth = (int)((float)maxWidth * this.textSize);
        return maxWidth += 20;
    }

    protected int getMaxHeight(Font fontRenderer) {
        int maxHeight = 12;
        if (this.textList.size() > 0) {
            maxHeight += 4 + this.textList.size() * 10;
        }
        maxHeight = (int)((float)maxHeight * this.textSize);
        return maxHeight;
    }

    @Override
    public void render(PoseStack matrixStack, Font fontRenderer, float zLevel, float partialTicks) {
        int renderBaseX = (int)((float)this.oldBaseX + (float)(this.baseX - this.oldBaseX) * partialTicks);
        int renderAffectedY = (int)((float)this.oldAffectedY + (float)(this.affectedY - this.oldAffectedY) * partialTicks);
        int renderWidth = (int)((float)this.oldWidth + (float)(this.width - this.oldWidth) * partialTicks);
        int renderHeight = (int)((float)this.oldHeight + (float)(this.height - this.oldHeight) * partialTicks);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        RenderSystem.m_69472_();
        RenderSystem.m_69832_((float)3.0f);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buff = tess.m_85915_();
        buff.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85817_);
        buff.m_5483_((double)renderBaseX, (double)renderAffectedY, (double)zLevel);
        buff.m_5483_((double)(renderBaseX + renderWidth), (double)renderAffectedY, (double)zLevel);
        buff.m_5483_((double)(renderBaseX + renderWidth), (double)(renderAffectedY + renderHeight), (double)zLevel);
        buff.m_5483_((double)renderBaseX, (double)(renderAffectedY + renderHeight), (double)zLevel);
        tess.m_85914_();
        RenderSystem.m_69493_();
        if (this.leftSided) {
            renderWidth *= -1;
        }
        if (this.doneExpanding) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(renderBaseX + (this.leftSided ? -renderWidth : 16)), (double)renderAffectedY, 0.0);
            matrixStack.m_85841_(this.textSize, this.textSize, this.textSize);
            matrixStack.m_85837_((double)(-renderBaseX - (this.leftSided ? -renderWidth : 16)), (double)(-renderAffectedY), 0.0);
            fontRenderer.m_92750_(matrixStack, this.title, (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + 2), 0xFFFF00);
            for (int i = 0; i < this.textList.size(); ++i) {
                if (this.textList.get(i).contains("\u00a70") || this.textList.get(i).contains(ChatFormatting.DARK_RED.toString())) {
                    fontRenderer.m_92883_(matrixStack, this.textList.get(i), (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + i * 10 + 12), 0xFFFFFF);
                    continue;
                }
                fontRenderer.m_92750_(matrixStack, this.textList.get(i), (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + i * 10 + 12), 0xFFFFFF);
            }
            matrixStack.m_85849_();
        }
        if (renderHeight > 16 && renderWidth > 16) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            if (this.iStack == null) {
                if (this.iconResLoc == null) {
                    this.iconResLoc = new ResourceLocation(this.texture);
                }
                GuiAnimatedStat.drawTexture(matrixStack.m_85850_().m_85861_(), this.iconResLoc, renderBaseX - (this.leftSided ? 16 : 0), renderAffectedY);
            } else if (this.gui != null || !(this.iStack.m_41720_() instanceof BlockItem)) {
                this.renderItem(matrixStack, fontRenderer, renderBaseX - (this.leftSided ? 16 : 0), renderAffectedY, this.iStack);
            }
        }
    }

    protected void renderItem(PoseStack matrixStack, Font fontRenderer, int x, int y, ItemStack stack) {
        if (this.itemRenderer == null) {
            this.itemRenderer = new ItemRenderer(Minecraft.m_91087_().m_91097_(), Minecraft.m_91087_().m_91291_().m_115103_().m_109393_(), Minecraft.m_91087_().getItemColors(), null);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, -50.0);
        this.itemRenderer.m_115203_(stack, x, y);
        this.itemRenderer.m_115174_(fontRenderer, stack, x, y, null);
        matrixStack.m_85849_();
    }

    public static void drawTexture(Matrix4f matrixStack, ResourceLocation texture, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrixStack, (float)x, (float)(y + 16), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrixStack, (float)(x + 16), (float)(y + 16), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrixStack, (float)(x + 16), (float)y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrixStack, (float)x, (float)y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    @Override
    public void onMouseClicked(int x, int y, int button) {
        if (button == 0 && this.mouseIsHoveringOverStat(x, y)) {
            this.isClicked = !this.isClicked;
            this.listener.actionPerformed(this);
        }
    }

    @Override
    public void closeWindow() {
        this.isClicked = false;
    }

    @Override
    public void openWindow() {
        this.isClicked = true;
    }

    @Override
    public boolean isClicked() {
        return this.isClicked;
    }

    private boolean mouseIsHoveringOverIcon(int x, int y) {
        if (this.leftSided) {
            return x <= this.baseX && x >= this.baseX - 16 && y >= this.affectedY && y <= this.affectedY + 16;
        }
        return x >= this.baseX && x <= this.baseX + 16 && y >= this.affectedY && y <= this.affectedY + 16;
    }

    private boolean mouseIsHoveringOverStat(int x, int y) {
        if (this.leftSided) {
            return x <= this.baseX && x >= this.baseX - this.width && y >= this.affectedY && y <= this.affectedY + this.height;
        }
        return x >= this.baseX && x <= this.baseX + this.width && y >= this.affectedY && y <= this.affectedY + this.height;
    }

    @Override
    public int getAffectedY() {
        return this.affectedY;
    }

    @Override
    public int getBaseX() {
        return this.baseX;
    }

    @Override
    public int getBaseY() {
        return this.baseY;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setBaseY(int y) {
        this.baseY = y;
    }

    @Override
    public void setTitle(String title) {
        this.title = I18n.m_118938_((String)title, (Object[])new Object[0]);
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public void setBaseX(int x) {
        this.baseX = x;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.listener = gui;
    }

    @Override
    public int getID() {
        return -1;
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        this.render(matrixStack, Minecraft.m_91087_().f_91062_, 0.0f, partialTick);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTip.add(this.title);
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.baseX - (this.leftSided ? this.width : 0), this.affectedY, this.width, this.height);
    }
}

