/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.gates;

import com.bluepowermod.block.BlockBase;
import com.bluepowermod.helper.DirectionHelper;
import com.bluepowermod.reference.Refs;
import com.bluepowermod.util.AABBUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockGateBase
extends BlockBase
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty POWERED_FRONT = BooleanProperty.m_61465_((String)"powered_front");
    public static final BooleanProperty POWERED_BACK = BooleanProperty.m_61465_((String)"powered_back");
    public static final BooleanProperty POWERED_LEFT = BooleanProperty.m_61465_((String)"powered_left");
    public static final BooleanProperty POWERED_RIGHT = BooleanProperty.m_61465_((String)"powered_right");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BlockGateBase() {
        super(Material.f_76313_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWERED_BACK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED_FRONT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED_LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED_RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ROTATION, POWERED_BACK, POWERED_FRONT, POWERED_LEFT, POWERED_RIGHT, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABBUtils.rotate(Refs.GATE_AABB, (Direction)state.m_61143_((Property)FACING));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return state.m_61143_((Property)FACING) != side && ((Direction)state.m_61143_((Property)FACING)).m_122424_() != side;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Direction face = context.m_43719_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(context.m_8125_().m_122424_().m_122416_()))).m_61124_((Property)FACING, (Comparable)face)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        Map<String, Byte> map = this.getSidePower((BlockGetter)world, state, pos);
        world.m_46597_(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)POWERED_FRONT, (Comparable)Boolean.valueOf(map.get("front") > 0))).m_61124_((Property)POWERED_BACK, (Comparable)Boolean.valueOf(map.get("back") > 0))).m_61124_((Property)POWERED_LEFT, (Comparable)Boolean.valueOf(map.get("left") > 0))).m_61124_((Property)POWERED_RIGHT, (Comparable)Boolean.valueOf(map.get("right") > 0)));
    }

    public boolean m_7899_(BlockState p_149744_1_) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        Direction[] dirs = DirectionHelper.ArrayFromDirection((Direction)blockState.m_61143_((Property)FACING));
        if (side == dirs[(Integer)blockState.m_61143_((Property)ROTATION)]) {
            Map<String, Byte> map = this.getSidePower(blockAccess, blockState, pos);
            return map.get("front").byteValue();
        }
        return 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        Direction[] dirs = DirectionHelper.ArrayFromDirection((Direction)blockState.m_61143_((Property)FACING));
        if (side == dirs[(Integer)blockState.m_61143_((Property)ROTATION)]) {
            Map<String, Byte> map = this.getSidePower(blockAccess, blockState, pos);
            return map.get("front").byteValue();
        }
        return 0;
    }

    private Map<String, Byte> getSidePower(BlockGetter worldIn, BlockState state, BlockPos pos) {
        HashMap<String, Byte> map = new HashMap<String, Byte>();
        Direction[] dirs = DirectionHelper.ArrayFromDirection((Direction)state.m_61143_((Property)FACING));
        Direction side_left = dirs[(Integer)state.m_61143_((Property)ROTATION) == 3 ? 0 : (Integer)state.m_61143_((Property)ROTATION) + 1];
        Direction side_right = side_left.m_122424_();
        Direction side_back = dirs[(Integer)state.m_61143_((Property)ROTATION)];
        BlockPos pos_left = pos.m_121945_(side_left);
        BlockPos pos_right = pos.m_121945_(side_right);
        BlockPos pos_back = pos.m_121945_(side_back);
        BlockState state_left = worldIn.m_8055_(pos_left);
        BlockState state_right = worldIn.m_8055_(pos_right);
        BlockState state_back = worldIn.m_8055_(pos_back);
        byte left = (byte)state_left.m_60746_(worldIn, pos_left, side_right);
        byte right = (byte)state_right.m_60746_(worldIn, pos_right, side_left);
        byte back = (byte)state_back.m_60746_(worldIn, pos_back, side_back.m_122424_());
        if (state_left.m_60734_() instanceof RedStoneWireBlock) {
            left = ((Integer)state_left.m_61143_((Property)RedStoneWireBlock.f_55500_)).byteValue();
        }
        if (state_right.m_60734_() instanceof RedStoneWireBlock) {
            right = ((Integer)state_right.m_61143_((Property)RedStoneWireBlock.f_55500_)).byteValue();
        }
        if (state_back.m_60734_() instanceof RedStoneWireBlock) {
            back = ((Integer)state_back.m_61143_((Property)RedStoneWireBlock.f_55500_)).byteValue();
        }
        map.put("left", left);
        map.put("right", right);
        map.put("back", back);
        map.put("front", this.computeRedstone(back, left, right));
        return map;
    }

    public byte computeRedstone(byte back, byte left, byte right) {
        if (left > 0 && right > 0) {
            return (byte)(back > 0 ? 16 : 0);
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        super.m_6861_(state, world, pos, blockIn, fromPos, bool);
        if (!world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60838_((BlockGetter)world, pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()))) {
            world.m_46961_(pos, true);
            return;
        }
        Map<String, Byte> map = this.getSidePower((BlockGetter)world, state, pos);
        world.m_46597_(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)POWERED_FRONT, (Comparable)Boolean.valueOf(map.get("front") > 0))).m_61124_((Property)POWERED_BACK, (Comparable)Boolean.valueOf(map.get("back") > 0))).m_61124_((Property)POWERED_LEFT, (Comparable)Boolean.valueOf(map.get("left") > 0))).m_61124_((Property)POWERED_RIGHT, (Comparable)Boolean.valueOf(map.get("right") > 0)));
    }
}

