/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.util.MultipartUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockBPMultipart
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BlockBPMultipart() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_().m_60978_(2.0f));
        BPBlocks.blockList.add((Block)this);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : TileBPMultipart::tickMultipart;
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_ && !this.m_5940_(state, (BlockGetter)worldIn, pos, CollisionContext.m_82749_()).equals(Shapes.m_83144_())) {
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE), 3);
                worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            }
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileBPMultipart) {
            ArrayList shapeList = new ArrayList();
            ((TileBPMultipart)te).getStates().forEach(s -> shapeList.add(s.m_60808_(worldIn, pos)));
            if (shapeList.size() > 0) {
                return shapeList.stream().reduce((VoxelShape)shapeList.get(0), Shapes::m_83110_);
            }
        }
        return Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockState partState = MultipartUtils.getClosestState((Entity)player, pos);
        BlockEntity te = world.m_7702_(pos);
        if (partState != null && partState.m_60734_() instanceof IBPPartBlock && te instanceof TileBPMultipart) {
            ((TileBPMultipart)te).removeState(partState);
            ((IBPPartBlock)partState.m_60734_()).onMultipartReplaced(partState, world, pos, state, false);
            world.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemStack = ItemStack.f_41583_;
        BlockState partState = MultipartUtils.getClosestState((Entity)player, pos);
        if (partState != null) {
            itemStack = partState.getCloneItemStack(target, world, pos, player);
        }
        return itemStack;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileentity = (BlockEntity)builder.m_78970_(LootContextParams.f_81462_);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (tileentity instanceof TileBPMultipart) {
            ((TileBPMultipart)tileentity).getStates().forEach(s -> itemStacks.addAll(s.m_60734_().m_7381_(s, builder)));
        }
        return itemStacks;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileBPMultipart) {
            ((TileBPMultipart)te).getStates().forEach(s -> s.m_60690_(world, pos, blockIn, fromPos, bool));
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileBPMultipart(pos, state);
    }
}

