/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.items.AEBaseItem;
import appeng.menu.me.interaction.ContainerItemContext;
import appeng.menu.me.interaction.StackInteractions;
import appeng.util.Platform;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class WrappedGenericStack
extends AEBaseItem {
    private static final String NBT_AMOUNT = "#";

    public static ItemStack wrap(GenericStack stack) {
        Objects.requireNonNull(stack, "stack");
        return WrappedGenericStack.wrap(stack.what(), stack.amount());
    }

    public static ItemStack wrap(AEKey what, long amount) {
        Objects.requireNonNull(what, "what");
        WrappedGenericStack item = AEItems.WRAPPED_GENERIC_STACK.m_5456_();
        ItemStack result = new ItemStack((ItemLike)item);
        CompoundTag tag = what.toTagGeneric();
        if (amount != 0L) {
            tag.m_128356_(NBT_AMOUNT, amount);
        }
        result.m_41751_(tag);
        return result;
    }

    public WrappedGenericStack(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Nullable
    public AEKey unwrapWhat(ItemStack stack) {
        if (stack.m_41720_() != this) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        return AEKey.fromTagGeneric(tag);
    }

    public long unwrapAmount(ItemStack stack) {
        if (stack.m_41720_() != this) {
            return 0L;
        }
        long amount = 0L;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(NBT_AMOUNT)) {
            amount = stack.m_41783_().m_128454_(NBT_AMOUNT);
        }
        return amount;
    }

    public static void modifyTooltip(ItemStack itemStack, List<Component> lines) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof WrappedGenericStack)) {
            return;
        }
        WrappedGenericStack item2 = (WrappedGenericStack)item;
        AEKey key = item2.unwrapWhat(itemStack);
        if (key != null) {
            for (int i = lines.size() - 1; i >= 0; --i) {
                Component line = lines.get(i);
                if (!line.getString().equals("\u00a79\u00a7oApplied Energistics 2")) continue;
                String modId = Platform.formatModName(key.getModId());
                lines.set(i, (Component)Component.m_237113_((String)modId));
                break;
            }
        }
    }

    public boolean m_142305_(ItemStack itemInSlot, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess otherItemAccess) {
        ContainerItemContext heldContainer;
        if (player.f_36096_ == null) {
            return true;
        }
        AEKey what = this.unwrapWhat(itemInSlot);
        if (clickAction == ClickAction.PRIMARY && (heldContainer = StackInteractions.findCarriedContextForKey(what, player, player.f_36096_)) != null) {
            long amount = this.unwrapAmount(itemInSlot);
            long inserted = heldContainer.insert(what, amount, Actionable.MODULATE);
            if (player.m_9236_().f_46443_) {
                heldContainer.playFillSound(player, what);
            }
            if (inserted >= amount) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_5852_(WrappedGenericStack.wrap(what, amount - inserted));
            }
        }
        return true;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }
}

