/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jeirei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public final class FluidBlockRendering {
    private FluidBlockRendering() {
    }

    public static void render(PoseStack stack, Fluid fluid, int x, int y, int width, int height) {
        FluidState fluidState = fluid.m_76145_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
        renderType.m_110185_();
        RenderSystem.m_69465_();
        PoseStack worldMatStack = RenderSystem.m_157191_();
        worldMatStack.m_85836_();
        worldMatStack.m_166854_(stack.m_85850_().m_85861_());
        worldMatStack.m_85837_((double)x, (double)y, 0.0);
        FogRenderer.m_109017_();
        worldMatStack.m_85837_((double)((float)width / 2.0f), (double)((float)height / 2.0f), 0.0);
        worldMatStack.m_85841_((float)width, (float)height, 1.0f);
        FluidBlockRendering.setupOrtographicProjection(worldMatStack);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        blockRenderer.m_234363_(BlockPos.f_121853_, (BlockAndTintGetter)new FakeWorld(fluidState), (VertexConsumer)builder, fluidState.m_76188_(), fluidState);
        if (builder.m_85732_()) {
            tesselator.m_85914_();
        }
        renderType.m_110188_();
        worldMatStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static void setupOrtographicProjection(PoseStack worldMatStack) {
        float angle = 36.0f;
        float rotation = 45.0f;
        worldMatStack.m_85841_(1.0f, 1.0f, -1.0f);
        worldMatStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
        Quaternion flip = Vector3f.f_122227_.m_122240_(180.0f);
        flip.m_80148_(Vector3f.f_122223_.m_122240_(angle));
        Quaternion rotate = Vector3f.f_122225_.m_122240_(rotation);
        worldMatStack.m_85845_(flip);
        worldMatStack.m_85845_(rotate);
        worldMatStack.m_85837_(-0.5, -0.5, -0.5);
        RenderSystem.m_157182_();
    }

    private static class FakeWorld
    implements BlockAndTintGetter {
        private final FluidState fluidState;

        public FakeWorld(FluidState fluidState) {
            this.fluidState = fluidState;
        }

        public float m_7717_(Direction direction, boolean bl) {
            return 1.0f;
        }

        public LevelLightEngine m_5518_() {
            throw new UnsupportedOperationException();
        }

        public int m_45517_(LightLayer lightLayer, BlockPos blockPos) {
            return 15;
        }

        public int m_45524_(BlockPos blockPos, int i) {
            return 15;
        }

        public int m_6171_(BlockPos blockPos, ColorResolver colorResolver) {
            return colorResolver.m_130045_((Biome)BuiltinRegistries.f_123865_.m_123013_(Biomes.f_48173_), 0.0, 0.0);
        }

        public BlockEntity m_7702_(BlockPos blockPos) {
            return null;
        }

        public BlockState m_8055_(BlockPos blockPos) {
            if (blockPos.equals((Object)BlockPos.f_121853_)) {
                return this.fluidState.m_76188_();
            }
            return Blocks.f_50016_.m_49966_();
        }

        public FluidState m_6425_(BlockPos blockPos) {
            if (blockPos.equals((Object)BlockPos.f_121853_)) {
                return this.fluidState;
            }
            return Fluids.f_76191_.m_76145_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }
    }
}

