/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.TickScheduler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileWirelessModem
extends TileGeneric {
    private final boolean advanced;
    private final ModemPeripheral modem;
    private boolean destroyed = false;
    private LazyOptional<IPeripheral> modemCap;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);

    public TileWirelessModem(BlockEntityType<? extends TileWirelessModem> type, BlockPos pos, BlockState state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
        this.modem = new Peripheral(this);
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule(this.tickToken);
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.modem.destroy();
            this.destroyed = true;
        }
    }

    @Deprecated
    public void m_155250_(@Nonnull BlockState state) {
        Direction direction = this.getDirection();
        super.m_155250_(state);
        if (this.getDirection() != direction) {
            this.modemCap = CapabilityUtil.invalidate(this.modemCap);
        }
    }

    @Override
    public void blockTick() {
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
    }

    @Nonnull
    private Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockWirelessModem.FACING);
    }

    private void updateBlockState() {
        boolean on = this.modem.getModemState().isOpen();
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)BlockWirelessModem.ON) != on) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)BlockWirelessModem.ON, (Comparable)Boolean.valueOf(on)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (side != null && this.getDirection() != side) {
                return LazyOptional.empty();
            }
            if (this.modemCap == null) {
                this.modemCap = LazyOptional.of(() -> this.modem);
            }
            return this.modemCap.cast();
        }
        return super.getCapability(cap, side);
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final TileWirelessModem entity;

        Peripheral(TileWirelessModem entity) {
            super(new ModemState(() -> TickScheduler.schedule(entity.tickToken)), entity.advanced);
            this.entity = entity;
        }

        @Override
        @Nonnull
        public Level getLevel() {
            return this.entity.m_58904_();
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            return Vec3.m_82528_((Vec3i)this.entity.m_58899_().m_121945_(this.entity.getDirection()));
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && this.entity == ((Peripheral)other).entity;
        }

        @Override
        @Nonnull
        public Object getTarget() {
            return this.entity;
        }
    }
}

