/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.container;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkHooks;

public interface ContainerData {
    public void toBytes(FriendlyByteBuf var1);

    default public void open(Player player, MenuProvider owner) {
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)owner, this::toBytes);
    }

    public static <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> toType(Function<FriendlyByteBuf, T> reader, Factory<C, T> factory) {
        return IForgeMenuType.create((id, player, data) -> factory.create(id, player, (ContainerData)reader.apply(data)));
    }

    public static <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> toType(Function<FriendlyByteBuf, T> reader, FixedFactory<C, T> factory) {
        return new FixedPointContainerFactory<C, T>(reader, factory).type;
    }

    public static interface Factory<C extends AbstractContainerMenu, T extends ContainerData> {
        public C create(int var1, @Nonnull Inventory var2, T var3);
    }

    public static final class FixedPointContainerFactory<C extends AbstractContainerMenu, T extends ContainerData>
    implements IContainerFactory<C> {
        private final IContainerFactory<C> impl;
        private final MenuType<C> type;

        private FixedPointContainerFactory(Function<FriendlyByteBuf, T> reader, FixedFactory<C, T> factory) {
            MenuType type = this.type = IForgeMenuType.create((IContainerFactory)this);
            this.impl = (id, player, data) -> factory.create(type, id, player, (ContainerData)reader.apply(data));
        }

        public C create(int windowId, Inventory inv, FriendlyByteBuf data) {
            return (C)this.impl.create(windowId, inv, data);
        }
    }

    public static interface FixedFactory<C extends AbstractContainerMenu, T extends ContainerData> {
        public C create(MenuType<C> var1, int var2, @Nonnull Inventory var3, T var4);
    }
}

