/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.IUpgradeBase;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class UpgradeRecipeGenerator<T> {
    private static final ResourceLocation TURTLE_UPGRADE = new ResourceLocation("computercraft", "turtle_upgrade");
    private static final ResourceLocation POCKET_UPGRADE = new ResourceLocation("computercraft", "pocket_upgrade");
    private final Function<CraftingRecipe, T> wrap;
    private final Map<Item, List<UpgradeInfo>> upgradeItemLookup = new HashMap<Item, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    public UpgradeRecipeGenerator(Function<CraftingRecipe, T> wrap) {
        this.wrap = wrap;
    }

    private void setupCache() {
        UpgradeInfo info;
        ItemStack stack;
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        for (ITurtleUpgrade iTurtleUpgrade : TurtleUpgrades.instance().getUpgrades()) {
            stack = iTurtleUpgrade.getCraftingItem();
            if (stack.m_41619_()) {
                return;
            }
            info = new UpgradeInfo(stack, iTurtleUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.m_41720_(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        }
        for (IPocketUpgrade iPocketUpgrade : PocketUpgrades.instance().getUpgrades()) {
            stack = iPocketUpgrade.getCraftingItem();
            if (stack.m_41619_()) {
                return;
            }
            info = new UpgradeInfo(stack, iPocketUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.m_41720_(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        }
    }

    public boolean isUpgrade(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.m_41720_());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.m_41619_() || craftingStack.m_41720_() != stack.m_41720_() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    public List<T> findRecipesWithInput(ItemStack stack) {
        this.setupCache();
        Item item = stack.m_41720_();
        if (item instanceof ItemTurtle) {
            ItemTurtle item2 = (ItemTurtle)item;
            ITurtleUpgrade left = item2.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item2.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return Collections.emptyList();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (left == null) {
                    recipes.add(this.turtle(ingredient, upgrade.ingredient, UpgradeRecipeGenerator.turtleWith(stack, upgrade.turtle, right)));
                }
                if (right != null) continue;
                recipes.add(this.turtle(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.turtleWith(stack, left, upgrade.turtle)));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.m_41720_() instanceof ItemPocketComputer) {
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                return Collections.emptyList();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                recipes.add(this.pocket(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.pocketWith(stack, upgrade.pocket)));
            }
            return Collections.unmodifiableList(recipes);
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.m_41720_());
        if (upgrades == null) {
            return Collections.emptyList();
        }
        List recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.m_41619_() || craftingStack.m_41720_() != stack.m_41720_() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? Collections.emptyList() : Collections.unmodifiableList(recipes);
    }

    public List<T> findRecipesWithOutput(ItemStack stack) {
        ArrayList<T> recipes;
        Item item = stack.m_41720_();
        if (item instanceof ItemTurtle) {
            ItemTurtle item2 = (ItemTurtle)item;
            recipes = new ArrayList<T>(0);
            ITurtleUpgrade left = item2.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item2.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(this.turtle(Ingredient.m_43927_((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, null, right)}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{left.getCraftingItem()}), stack));
            }
            if (right != null) {
                recipes.add(this.turtle(Ingredient.m_43927_((ItemStack[])new ItemStack[]{right.getCraftingItem()}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, left, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.m_41720_() instanceof ItemPocketComputer) {
            recipes = new ArrayList(0);
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                recipes.add(this.pocket(Ingredient.m_43927_((ItemStack[])new ItemStack[]{back.getCraftingItem()}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.pocketWith(stack, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        return Collections.emptyList();
    }

    private static ItemStack turtleWith(ItemStack stack, @Nullable ITurtleUpgrade left, @Nullable ITurtleUpgrade right) {
        ItemTurtle item = (ItemTurtle)stack.m_41720_();
        return TurtleItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), left, right, item.getFuelLevel(stack), item.getOverlay(stack));
    }

    private static ItemStack pocketWith(ItemStack stack, @Nullable IPocketUpgrade back) {
        ItemPocketComputer item = (ItemPocketComputer)stack.m_41720_();
        return PocketComputerItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), back);
    }

    private T pocket(Ingredient upgrade, Ingredient pocketComputer, ItemStack result) {
        return this.wrap.apply((CraftingRecipe)new ShapedRecipe(POCKET_UPGRADE, "", 1, 2, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{upgrade, pocketComputer}), result));
    }

    private T turtle(Ingredient left, Ingredient right, ItemStack result) {
        return this.wrap.apply((CraftingRecipe)new ShapedRecipe(TURTLE_UPGRADE, "", 2, 1, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{left, right}), result));
    }

    private class UpgradeInfo {
        final ItemStack stack;
        final Ingredient ingredient;
        @Nullable
        final ITurtleUpgrade turtle;
        @Nullable
        final IPocketUpgrade pocket;
        final IUpgradeBase upgrade;
        @Nullable
        private ArrayList<T> recipes;

        UpgradeInfo(ItemStack stack, ITurtleUpgrade turtle) {
            this.stack = stack;
            this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            this.turtle = turtle;
            this.upgrade = this.turtle;
            this.pocket = null;
        }

        UpgradeInfo(ItemStack stack, IPocketUpgrade pocket) {
            this.stack = stack;
            this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            this.turtle = null;
            this.pocket = pocket;
            this.upgrade = this.pocket;
        }

        List<T> getRecipes() {
            ArrayList<Object> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            for (ComputerFamily family : RecipeModHelpers.MAIN_FAMILIES) {
                if (this.turtle != null) {
                    recipes.add(UpgradeRecipeGenerator.this.turtle(this.ingredient, Ingredient.m_43927_((ItemStack[])new ItemStack[]{TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null)}), TurtleItemFactory.create(-1, null, -1, family, null, this.turtle, 0, null)));
                }
                if (this.pocket == null) continue;
                recipes.add(UpgradeRecipeGenerator.this.pocket(this.ingredient, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PocketComputerItemFactory.create(-1, null, -1, family, null)}), PocketComputerItemFactory.create(-1, null, -1, family, this.pocket)));
            }
            recipes.trimToSize();
            return recipes;
        }
    }
}

