/*
 * Decompiled with CFR 0.152.
 */
package squeek.wthitharvestability.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.TierSortingRegistry;

public class StringHelper {
    public static final List<Function<Tier, String>> TIER_NAME_GETTERS = new ArrayList<Function<Tier, String>>();

    public static String getHarvestLevelName(Tier tier) {
        for (Function<Tier, String> getter : TIER_NAME_GETTERS) {
            String name = getter.apply(tier);
            if (name == null) continue;
            return name;
        }
        String unlocalized = Util.m_137492_((String)"waila.h12y.tier", (ResourceLocation)TierSortingRegistry.getName((Tier)tier));
        if (I18n.m_118936_((String)unlocalized)) {
            return I18n.m_118938_((String)unlocalized, (Object[])new Object[0]);
        }
        return String.valueOf(tier.m_6604_());
    }

    public static Component concatenateStringList(List<Component> textComponents, String separator) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Component s : textComponents) {
            sb.append(sep).append(s.getString());
            sep = separator;
        }
        return Component.m_237113_((String)sb.toString());
    }

    public static String stripFormatting(String str) {
        return ChatFormatting.m_126649_((String)str);
    }
}

