/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeResults;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.ItemKeyPair;
import dev.ftb.mods.ftbic.util.MachineProcessingResult;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class CanningMachineRecipeResults
extends MachineRecipeResults {
    private List<MachineRecipe> allRecipes;
    private Set<Item> validLeftItems;
    private Set<Item> validRightItems;

    @Override
    public int getRequiredItems() {
        return 2;
    }

    @Override
    public Object createKey(ItemStack[] inputs) {
        return new ItemKeyPair(inputs[0], inputs[1]);
    }

    @Override
    public List<MachineRecipe> getAllRecipes(Level level) {
        if (this.allRecipes == null) {
            this.allRecipes = new ArrayList<MachineRecipe>(level.m_7465_().m_44013_(((MachineRecipeSerializer)FTBICRecipes.CANNING.get()).recipeType));
            if (((Boolean)FTBICConfig.RECIPES.ADD_CANNED_FOOD_RECIPES.get()).booleanValue()) {
                Ingredient canIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FTBICItems.EMPTY_CAN.item.get()});
                for (Item item : ForgeRegistries.ITEMS) {
                    int cans;
                    FoodProperties f = item.m_41473_();
                    if (f == null || f.m_38744_() <= 1 || !f.m_38749_().isEmpty() || item.m_204114_().m_203656_(FTBICUtils.UNCANNABLE_FOOD) || (cans = (f.m_38744_() + (f.m_38746_() ? 8 : 3)) / 4) <= 0) continue;
                    ResourceLocation id = Registry.f_122827_.m_7981_((Object)item);
                    MachineRecipe recipe = new MachineRecipe((MachineRecipeSerializer)FTBICRecipes.CANNING.get(), new ResourceLocation("ftbic", "canning/generated/canned_food/" + id.m_135827_() + "/" + id.m_135815_()));
                    recipe.inputItems.add(new IngredientWithCount(canIngredient, cans));
                    recipe.inputItems.add(new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), 1));
                    recipe.outputItems.add(new StackWithChance(new ItemStack((ItemLike)FTBICItems.CANNED_FOOD.get(), cans), 1.0));
                    this.allRecipes.add(recipe);
                }
            }
        }
        return this.allRecipes;
    }

    @Override
    public MachineProcessingResult createResult(Level level, ItemStack[] inputs) {
        for (MachineRecipe recipe : this.getAllRecipes(level)) {
            if (recipe.inputItems.size() != 2 || recipe.outputItems.size() < 1) continue;
            IngredientWithCount cA = recipe.inputItems.get(0);
            IngredientWithCount cB = recipe.inputItems.get(1);
            if (!cA.ingredient.test(inputs[0]) || !cB.ingredient.test(inputs[1])) continue;
            MachineProcessingResult result = new MachineProcessingResult(recipe);
            result.consume[0] = cA.count;
            result.consume[1] = cB.count;
            return result;
        }
        return MachineProcessingResult.NONE;
    }

    @Override
    public boolean canInsert(Level level, int slot, ItemStack item) {
        if (slot == 0) {
            if (this.validLeftItems == null) {
                this.validLeftItems = new HashSet<Item>();
                for (MachineRecipe recipe : this.getAllRecipes(level)) {
                    if (recipe.inputItems.size() != 2 || recipe.outputItems.size() < 1) continue;
                    Arrays.stream(recipe.inputItems.get((int)0).ingredient.m_43908_()).map(ItemStack::m_41720_).forEach(this.validLeftItems::add);
                }
            }
            return this.validLeftItems.contains(item.m_41720_());
        }
        if (slot == 1) {
            if (this.validRightItems == null) {
                this.validRightItems = new HashSet<Item>();
                for (MachineRecipe recipe : this.getAllRecipes(level)) {
                    if (recipe.inputItems.size() != 2 || recipe.outputItems.size() < 1) continue;
                    Arrays.stream(recipe.inputItems.get((int)1).ingredient.m_43908_()).map(ItemStack::m_41720_).forEach(this.validRightItems::add);
                }
            }
            return this.validRightItems.contains(item.m_41720_());
        }
        return false;
    }
}

