/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.ftb.mods.ftbic.world.ICBiomeTags;
import dev.ftb.mods.ftbic.world.OreBiomeModifier;
import dev.ftb.mods.ftbic.world.OreGeneration;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBICBiomeModifierDataGen
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RegistryOps<JsonElement> ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)RegistryAccess.f_123049_.get()));
    private final Path modifierPath;
    private final OreBiomeModifier oreBiomeModifier;

    public FTBICBiomeModifierDataGen(DataGenerator gen, String modid) {
        Registry placedFeatures = (Registry)this.ops.m_206826_(Registry.f_194567_).get();
        DataGenerator.PathProvider pathProvider = gen.m_236036_(DataGenerator.Target.DATA_PACK, ForgeRegistries.Keys.BIOME_MODIFIERS.m_135782_().toString().replace(":", "/"));
        this.modifierPath = pathProvider.m_236048_(new ResourceLocation(modid, "ftbic_ore_biome_modifier"));
        this.oreBiomeModifier = new OreBiomeModifier((HolderSet<Biome>)new HolderSet.Named((Registry)this.ops.m_206826_(Registry.f_122885_).get(), ICBiomeTags.ORE_SPAWN_BLACKLIST), GenerationStep.Decoration.UNDERGROUND_ORES, (HolderSet<PlacedFeature>)HolderSet.m_205800_(OreGeneration.PLACEMENTS.stream().map(e -> placedFeatures.m_214121_(e.getKey())).toList()));
    }

    public void m_213708_(CachedOutput cache) {
        BiomeModifier.DIRECT_CODEC.encodeStart(this.ops, (Object)this.oreBiomeModifier).resultOrPartial(msg -> LOGGER.error("Failed to encode {}: {}", (Object)this.modifierPath.toAbsolutePath(), msg)).ifPresent(json -> {
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)this.modifierPath);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save " + this.modifierPath.toAbsolutePath(), (Throwable)e);
            }
        });
    }

    public String m_6055_() {
        return "ftbic biome modifier data provider";
    }
}

