/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic;

import com.mojang.serialization.Codec;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbic.FTBICCommon;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.FTBICBlockEntities;
import dev.ftb.mods.ftbic.client.FTBICClient;
import dev.ftb.mods.ftbic.entity.FTBICEntities;
import dev.ftb.mods.ftbic.item.DummyEnergyArmorItem;
import dev.ftb.mods.ftbic.item.EnergyArmorItem;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.net.FTBICNet;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.screen.FTBICMenus;
import dev.ftb.mods.ftbic.sound.FTBICSounds;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.world.OreBiomeModifier;
import dev.ftb.mods.ftbic.world.OreGeneration;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ftbic")
@Mod.EventBusSubscriber(modid="ftbic")
public class FTBIC {
    public static final String MOD_ID = "ftbic";
    public static final String MOD_NAME = "FTB Industrial Contraptions";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Industrial Contraptions");
    public static FTBICCommon PROXY;
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_SERIALIZERS;
    public static final RegistryObject<Codec<OreBiomeModifier>> ORE_BIOME_MODIFIER;
    public static final List<DeferredRegister<?>> REGISTERS;
    public static final CreativeModeTab TAB;

    public FTBIC() {
        PROXY = (FTBICCommon)DistExecutor.safeRunForDist(() -> FTBICClient::new, () -> FTBICCommon::new);
        Path configPath = Platform.getConfigFolder().resolve("ftbic-common.snbt");
        FTBICConfig.CONFIG.load(configPath);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        REGISTERS.forEach(e -> e.register(modEventBus));
        FTBICConfig.init();
        FTBICElectricBlocks.init();
        FTBICUtils.init();
        FTBICNet.init();
        PROXY.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(OreGeneration::init);
    }

    private static boolean isDummyArmor(LivingDamageEvent event, EquipmentSlot slot, ArmorMaterial material) {
        Item item = event.getEntity().m_6844_(slot).m_41720_();
        return item instanceof DummyEnergyArmorItem && ((DummyEnergyArmorItem)item).m_40401_() == material;
    }

    @SubscribeEvent
    public static void playerDamage(LivingDamageEvent event) {
        EnergyArmorItem armorItem;
        ItemStack stack;
        Item item;
        if (!event.getSource().m_19378_() && event.getEntity() instanceof Player && (item = (stack = event.getEntity().m_6844_(EquipmentSlot.CHEST)).m_41720_()) instanceof EnergyArmorItem && (armorItem = (EnergyArmorItem)item).getEnergy(stack) > 0.0) {
            float protection = 0.35f;
            if (FTBIC.isDummyArmor(event, EquipmentSlot.HEAD, armorItem.m_40401_())) {
                protection += 0.25f;
            }
            if (FTBIC.isDummyArmor(event, EquipmentSlot.LEGS, armorItem.m_40401_())) {
                protection += 0.35f;
            }
            if (FTBIC.isDummyArmor(event, EquipmentSlot.FEET, armorItem.m_40401_())) {
                protection += 0.15f;
            }
            float amountReduced = event.getAmount() * Math.min(protection, 1.0f);
            double energy = (Double)FTBICConfig.EQUIPMENT.ARMOR_DAMAGE_ENERGY.get() * (double)amountReduced;
            armorItem.damageEnergyItem(stack, energy);
            event.setAmount(event.getAmount() - amountReduced);
        }
    }

    static {
        BIOME_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MOD_ID);
        ORE_BIOME_MODIFIER = BIOME_SERIALIZERS.register("ore_biome_modifiers", () -> OreBiomeModifier.CODEC);
        REGISTERS = List.of(FTBICBlocks.REGISTRY, FTBICItems.REGISTRY, FTBICBlockEntities.REGISTRY, FTBICRecipes.REGISTRY, FTBICRecipes.REGISTRY_TYPE, FTBICMenus.REGISTRY, FTBICEntities.REGISTRY, FTBICSounds.REGISTRY, FTBICUtils.LOOT_REGISTRY, OreGeneration.FEATURE_REGISTRY, OreGeneration.PLACED_FEATURE_REGISTRY, BIOME_SERIALIZERS);
        TAB = new CreativeModeTab(MOD_ID){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)FTBICElectricBlocks.POWERED_FURNACE.item.get());
            }
        };
    }
}

