/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.network.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class PlayMusicAtPosMessage
implements IMessage {
    private SoundEvent soundEvent;
    private BlockPos pos;
    private ResourceKey<Level> dimensionID;
    private float volume;
    private float pitch;

    public PlayMusicAtPosMessage() {
    }

    public PlayMusicAtPosMessage(SoundEvent event, BlockPos pos, Level world, float volume, float pitch) {
        this.soundEvent = event;
        this.pos = pos;
        this.dimensionID = world.m_46472_();
        this.volume = volume;
        this.pitch = pitch;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(Registry.f_122821_.m_7447_((Object)this.soundEvent));
        buf.m_130064_(this.pos);
        buf.m_130070_(this.dimensionID.m_135782_().toString());
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.soundEvent = (SoundEvent)Registry.f_122821_.m_7942_(buf.m_130242_());
        this.pos = buf.m_130135_();
        this.dimensionID = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.m_91087_().f_91073_.m_46472_() == this.dimensionID) {
            Minecraft.m_91087_().f_91073_.m_6263_((Player)Minecraft.m_91087_().f_91074_, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), this.soundEvent, SoundSource.AMBIENT, this.volume, this.pitch);
        }
    }
}

