/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.util.ExperienceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenSkillHandler
implements ICitizenSkillHandler {
    public Map<Skill, Tuple<Integer, Double>> skillMap = new HashMap<Skill, Tuple<Integer, Double>>();

    @Override
    public void init(int levelCap) {
        if (levelCap <= 1) {
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)1, (Object)0.0));
            }
        } else {
            Random random = new Random();
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)(random.nextInt(levelCap - 1) + 1), (Object)0.0));
            }
        }
    }

    @Override
    public void init(@NotNull IColony colony, @Nullable ICitizenData firstParent, @Nullable ICitizenData secondParent, Random rand) {
        ICitizenData roleModelA = firstParent == null ? colony.getCitizenManager().getRandomCitizen() : firstParent;
        ICitizenData roleModelB = secondParent == null ? colony.getCitizenManager().getRandomCitizen() : secondParent;
        int levelCap = (int)colony.getOverallHappiness();
        this.init(levelCap);
        int bonusPoints = 25 + rand.nextInt(25);
        int totalPoints = 0;
        for (Skill skill : Skill.values()) {
            int firstRoleModelLevel = (Integer)roleModelA.getCitizenSkillHandler().getSkills().get((Object)skill).m_14418_();
            int secondRoleModelLevel = (Integer)roleModelB.getCitizenSkillHandler().getSkills().get((Object)skill).m_14418_();
            totalPoints += firstRoleModelLevel + secondRoleModelLevel;
        }
        for (Skill skill : Skill.values()) {
            double firstRoleModelLevel = ((Integer)roleModelA.getCitizenSkillHandler().getSkills().get((Object)skill).m_14418_()).intValue();
            double secondRoleModelLevel = ((Integer)roleModelB.getCitizenSkillHandler().getSkills().get((Object)skill).m_14418_()).intValue();
            int newPoints = (int)((firstRoleModelLevel + secondRoleModelLevel) / (double)totalPoints * (double)bonusPoints);
            this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)((Integer)this.skillMap.get((Object)skill).m_14418_() + newPoints), (Object)0.0));
        }
    }

    @Override
    @NotNull
    public CompoundTag write() {
        CompoundTag compoundNBT = new CompoundTag();
        @NotNull ListTag levelTagList = new ListTag();
        for (Map.Entry<Skill, Tuple<Integer, Double>> entry : this.skillMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            @NotNull CompoundTag levelCompound = new CompoundTag();
            levelCompound.m_128405_("skill", entry.getKey().ordinal());
            levelCompound.m_128405_("level", ((Integer)entry.getValue().m_14418_()).intValue());
            levelCompound.m_128347_("experience", ((Double)entry.getValue().m_14419_()).doubleValue());
            levelTagList.add((Object)levelCompound);
        }
        compoundNBT.m_128365_("levelMap", (Tag)levelTagList);
        return compoundNBT;
    }

    @Override
    public void read(@NotNull CompoundTag compoundNBT) {
        ListTag levelTagList = compoundNBT.m_128437_("levelMap", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            CompoundTag levelExperienceAtJob = levelTagList.m_128728_(i);
            this.skillMap.put(Skill.values()[levelExperienceAtJob.m_128451_("skill")], (Tuple<Integer, Double>)new Tuple((Object)Math.max(1, Math.min(levelExperienceAtJob.m_128451_("level"), 99)), (Object)levelExperienceAtJob.m_128459_("experience")));
        }
    }

    @Override
    public void tryLevelUpIntelligence(@NotNull Random random, double customChance, @NotNull ICitizenData citizen) {
        if (customChance > 0.0 && random.nextDouble() * customChance < 1.0) {
            return;
        }
        int levelCap = (int)citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony());
        if ((Integer)this.skillMap.get((Object)Skill.Intelligence).m_14418_() < levelCap * 9) {
            this.addXpToSkill(Skill.Intelligence, 10.0, citizen);
        }
    }

    @Override
    public int getLevel(@NotNull Skill skill) {
        return (Integer)this.skillMap.get((Object)skill).m_14418_();
    }

    @Override
    public void incrementLevel(@NotNull Skill skill, int level) {
        Tuple<Integer, Double> current = this.skillMap.get((Object)skill);
        this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.min(99, Math.max((Integer)current.m_14418_() + level, 1)), (Object)((Double)current.m_14419_())));
    }

    @Override
    public void addXpToSkill(Skill skill, double xp, ICitizenData data) {
        double citizenHutMaxLevel;
        Tuple<Integer, Double> tuple = this.skillMap.getOrDefault((Object)skill, (Tuple<Integer, Double>)new Tuple((Object)0, (Object)0.0));
        int level = (Integer)tuple.m_14418_();
        double currentXp = (Double)tuple.m_14419_();
        IBuilding home = data.getHomeBuilding();
        double citizenHutLevel = home == null ? 0.0 : (double)home.getBuildingLevel();
        double d = citizenHutMaxLevel = home == null ? 5.0 : (double)home.getMaxBuildingLevel();
        if ((citizenHutLevel < citizenHutMaxLevel || citizenHutMaxLevel < 5.0) && (citizenHutLevel + 1.0) * 10.0 <= (double)level || level >= 99) {
            return;
        }
        double xpToLevelUp = Math.min(Double.MAX_VALUE, currentXp + xp);
        while (xpToLevelUp > 0.0) {
            double nextLevel = ExperienceUtils.getXPNeededForNextLevel(level);
            if (nextLevel > xpToLevelUp) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.min(99, level), (Object)xpToLevelUp));
                xpToLevelUp = 0.0;
                continue;
            }
            xpToLevelUp -= nextLevel;
            ++level;
        }
        if (level > (Integer)tuple.m_14418_()) {
            this.levelUp(data);
            data.markDirty();
        }
    }

    @Override
    public void removeXpFromSkill(@NotNull Skill skill, double xp, @NotNull ICitizenData data) {
        Tuple<Integer, Double> tuple = this.skillMap.get((Object)skill);
        int level = (Integer)tuple.m_14418_();
        double currentXp = (Double)tuple.m_14419_();
        double xpToDiscount = xp;
        while (xpToDiscount > 0.0) {
            if (currentXp >= xpToDiscount || level <= 1) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.max(1, level), (Object)Math.max(0.0, currentXp - xpToDiscount)));
                break;
            }
            xpToDiscount -= currentXp;
            currentXp = ExperienceUtils.getXPNeededForNextLevel(level - 1);
            --level;
        }
        if (level < (Integer)tuple.m_14418_()) {
            data.markDirty();
        }
    }

    @Override
    public void levelUp(ICitizenData data) {
        if (data.getEntity().isPresent()) {
            AbstractEntityCitizen citizen = data.getEntity().get();
            citizen.m_5496_(SoundEvents.f_12275_, 1.0f, (float)SoundUtils.getRandomPitch(citizen.m_217043_()));
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(citizen.m_20185_(), citizen.m_20186_(), citizen.m_20189_(), ParticleTypes.f_123748_), (Entity)data.getEntity().get());
        }
        if (data.getJob() != null) {
            data.getJob().onLevelUp();
        }
    }

    @Override
    public double getTotalXP() {
        double totalXp = 0.0;
        for (Tuple<Integer, Double> tuple : this.skillMap.values()) {
            totalXp += ((Double)tuple.m_14419_()).doubleValue();
        }
        return totalXp;
    }

    @Override
    public Map<Skill, Tuple<Integer, Double>> getSkills() {
        return ImmutableMap.copyOf(this.skillMap);
    }
}

