/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.requests;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.RequestTag;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.jobs.views.CrafterJobView;
import com.minecolonies.coremod.colony.jobs.views.DmanJobView;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.colony.requestsystem.requests.AbstractRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class StandardRequests {
    private StandardRequests() {
    }

    private static int getPosInList(IColonyView colony, IBuildingView view, IToken<?> id) {
        if (view == null) {
            return 0;
        }
        for (WorkerBuildingModuleView moduleView : view.getModuleViews(WorkerBuildingModuleView.class)) {
            for (int worker : moduleView.getAssignedCitizens()) {
                int index;
                ICitizenDataView citizen = colony.getCitizen(worker);
                if (citizen == null || !(citizen.getJobView() instanceof CrafterJobView ? (index = ((CrafterJobView)citizen.getJobView()).getDataStore().getQueue().indexOf(id)) >= 0 : citizen.getJobView() instanceof DmanJobView && (index = ((DmanJobView)citizen.getJobView()).getDataStore().getQueue().indexOf(id)) >= 0)) continue;
                return index;
            }
        }
        return -1;
    }

    public static class BurnableRequest
    extends AbstractRequest<Burnable> {
        private static ImmutableList<ItemStack> burnableExamples;

        BurnableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Burnable requested) {
            super(requester, token, requested);
        }

        BurnableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Burnable requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent result = Component.m_237113_((String)"");
            result.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.request.burnable"));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (burnableExamples == null) {
                burnableExamples = ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems().stream().filter(AbstractFurnaceBlockEntity::m_58399_).collect(Collectors.toList()));
            }
            return burnableExamples;
        }
    }

    public static class SmeltAbleOreRequest
    extends AbstractRequest<SmeltableOre> {
        private static ImmutableList<ItemStack> oreExamples;

        SmeltAbleOreRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull SmeltableOre requested) {
            super(requester, token, requested);
        }

        SmeltAbleOreRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull SmeltableOre requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            return Component.m_237115_((String)"com.minecolonies.coremod.request.smeltableore");
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (oreExamples == null) {
                oreExamples = ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems().stream().filter(IColonyManager.getInstance().getCompatibilityManager()::isOre).collect(Collectors.toList()));
            }
            return oreExamples;
        }
    }

    public static class FoodRequest
    extends AbstractRequest<Food> {
        private static ImmutableList<ItemStack> foodExamples;

        FoodRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Food requested) {
            super(requester, token, requested);
        }

        FoodRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Food requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent result = Component.m_237113_((String)"");
            result.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.request.food"));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (foodExamples == null) {
                foodExamples = ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems().stream().filter(item -> item.m_41614_()).collect(Collectors.toList()));
            }
            if (!((Food)this.getRequest()).getExclusionList().isEmpty()) {
                return ImmutableList.copyOf((Collection)foodExamples.stream().filter(item -> ((Food)this.getRequest()).matches((ItemStack)item)).collect(Collectors.toList()));
            }
            return foodExamples;
        }
    }

    public static class ToolRequest
    extends AbstractRequest<Tool> {
        public ToolRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Tool requested) {
            super(requester, token, requested);
        }

        public ToolRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Tool requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public Component getLongDisplayString() {
            MutableComponent result = Component.m_237113_((String)"");
            MutableComponent preType = Component.m_237115_((String)"com.minecolonies.coremod.request.tool.pretype");
            result.m_7220_((Component)preType);
            result.m_7220_(((Tool)this.getRequest()).getToolClass().getDisplayName());
            if (((Tool)this.getRequest()).getMinLevel() > -1) {
                result.m_7220_((Component)Component.m_237113_((String)" "));
                result.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.request.tool.preminlevel"));
                result.m_7220_((Component)Component.m_237113_((String)(((Tool)this.getRequest()).isArmor() ? ItemStackUtils.swapArmorGrade(((Tool)this.getRequest()).getMinLevel()) : ItemStackUtils.swapToolGrade(((Tool)this.getRequest()).getMinLevel()))));
            }
            if (((Tool)this.getRequest()).getMaxLevel() < Integer.MAX_VALUE) {
                if (((Tool)this.getRequest()).getMinLevel() > -1) {
                    result.m_7220_((Component)Component.m_237113_((String)" "));
                    result.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.general.and"));
                }
                result.m_7220_((Component)Component.m_237113_((String)" "));
                result.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.request.tool.premaxlevel"));
                result.m_7220_((Component)Component.m_237113_((String)(((Tool)this.getRequest()).isArmor() ? ItemStackUtils.swapArmorGrade(((Tool)this.getRequest()).getMaxLevel()) : ItemStackUtils.swapToolGrade(((Tool)this.getRequest()).getMaxLevel()))));
            }
            return result;
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent result = Component.m_237113_((String)"");
            result.m_7220_(((Tool)this.getRequest()).getToolClass().getDisplayName());
            return result;
        }
    }

    public static class PublicCraftingRequest
    extends AbstractCraftingRequest<PublicCrafting> {
        protected PublicCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull PublicCrafting requested) {
            super(requester, token, requested);
        }

        protected PublicCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull PublicCrafting requested) {
            super(requester, token, state, requested);
        }

        @Override
        protected String getTranslationKey() {
            return "com.minecolonies.coremod.request.crafting";
        }

        @Override
        protected String getDisplayIconFile() {
            return "minecolonies:textures/gui/citizen/crafting_public.png";
        }
    }

    public static class PrivateCraftingRequest
    extends AbstractCraftingRequest<PrivateCrafting> {
        protected PrivateCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull PrivateCrafting requested) {
            super(requester, token, requested);
        }

        protected PrivateCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull PrivateCrafting requested) {
            super(requester, token, state, requested);
        }

        @Override
        protected String getTranslationKey() {
            return "com.minecolonies.coremod.request.crafting";
        }

        @Override
        protected String getDisplayIconFile() {
            return "minecolonies:textures/gui/citizen/crafting_public.png";
        }
    }

    public static abstract class AbstractCraftingRequest<C extends AbstractCrafting>
    extends AbstractRequest<C> {
        protected AbstractCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull C requested) {
            super(requester, token, requested);
        }

        protected AbstractCraftingRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull C requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public final Component getShortDisplayString() {
            return Component.m_237110_((String)"com.minecolonies.coremod.request.crafting.display", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(((AbstractCrafting)this.getRequest()).getMinCount())), ((AbstractCrafting)this.getRequest()).getStack().m_41611_()});
        }

        protected abstract String getTranslationKey();

        @Override
        @NotNull
        public final List<ItemStack> getDisplayStacks() {
            return ImmutableList.of();
        }

        @Override
        public List<MutableComponent> getResolverToolTip(IColonyView colony) {
            String requester = this.getRequester().getRequesterDisplayName(colony.getRequestManager(), this).getString();
            try {
                BlockPos resolver = colony.getRequestManager().getResolverForRequest((IToken<?>)this.getId()).getLocation().getInDimensionLocation();
                IBuildingView view = colony.getBuilding(resolver);
                int posInList = StandardRequests.getPosInList(colony, view, this.getId());
                if (posInList >= 0) {
                    return posInList == 0 ? ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.at", (Object[])new Object[]{requester}), (Object)Component.m_237115_((String)"com.minecolonies.coremod.in_progress")) : ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.from", (Object[])new Object[]{requester}), (Object)Component.m_237110_((String)"com.minecolonies.coremod.listentry", (Object[])new Object[]{posInList}));
                }
                if (this.getState() == RequestState.FOLLOWUP_IN_PROGRESS) {
                    return ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.at", (Object[])new Object[]{requester}), (Object)Component.m_237115_((String)"com.minecolonies.coremod.finished"));
                }
                return ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.at", (Object[])new Object[]{requester}), (Object)Component.m_237115_((String)"com.minecolonies.coremod.missingitems"));
            }
            catch (IllegalArgumentException ex) {
                return ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.at", (Object[])new Object[]{requester}), (Object)Component.m_237115_((String)"com.minecolonies.coremod.notresolved"));
            }
        }

        @Override
        @NotNull
        public final ResourceLocation getDisplayIcon() {
            return new ResourceLocation(this.getDisplayIconFile());
        }

        protected abstract String getDisplayIconFile();
    }

    public static class PickupRequest
    extends AbstractRequest<Pickup> {
        public PickupRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Pickup requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ImmutableList<ItemStack> getDeliveries() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent result = Component.m_237113_((String)"");
            result.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.request.pickup"));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public ResourceLocation getDisplayIcon() {
            return new ResourceLocation("minecolonies:textures/gui/citizen/delivery.png");
        }
    }

    public static class DeliveryRequest
    extends AbstractRequest<Delivery> {
        public DeliveryRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Delivery requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public ImmutableList<ItemStack> getDeliveries() {
            return ImmutableList.of();
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent result = Component.m_237113_((String)"");
            result.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.request.delivery").m_7220_((Component)Component.m_237113_((String)(((Delivery)this.getRequest()).getStack().m_41613_() + " "))).m_7220_(((Delivery)this.getRequest()).getStack().m_41611_()));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ImmutableList.of();
        }

        @Override
        public List<MutableComponent> getResolverToolTip(IColonyView colony) {
            String requester = this.getRequester().getRequesterDisplayName(colony.getRequestManager(), this).getString();
            int posInList = -1;
            for (IBuildingView view : colony.getBuildings()) {
                if (view.getBuildingType() == ModBuildings.deliveryman.get() && (posInList = StandardRequests.getPosInList(colony, view, this.getId())) >= 0) break;
            }
            if (posInList >= 0) {
                return posInList == 0 ? ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.from", (Object[])new Object[]{requester}), (Object)Component.m_237115_((String)"com.minecolonies.coremod.in_progress")) : ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.from", (Object[])new Object[]{requester}), (Object)Component.m_237110_((String)"com.minecolonies.coremod.listentry", (Object[])new Object[]{posInList}));
            }
            return ImmutableList.of((Object)Component.m_237110_((String)"com.minecolonies.coremod.from", (Object[])new Object[]{requester}));
        }

        @Override
        @NotNull
        public ResourceLocation getDisplayIcon() {
            return new ResourceLocation("minecolonies:textures/gui/citizen/delivery.png");
        }
    }

    public static class ItemTagRequest
    extends AbstractRequest<RequestTag> {
        private List<ItemStack> stacks;

        public ItemTagRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestTag requested) {
            super(requester, token, requested);
            this.stacks = ForgeRegistries.ITEMS.tags().getTag(requested.getTag()).stream().flatMap(item -> {
                NonNullList list = NonNullList.m_122779_();
                item.m_6787_(item.m_41471_(), list);
                return list.stream();
            }).collect(Collectors.toList());
        }

        public ItemTagRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull RequestTag requested) {
            super(requester, token, state, requested);
            this.stacks = ForgeRegistries.ITEMS.tags().getTag(requested.getTag()).stream().flatMap(item -> {
                NonNullList list = NonNullList.m_122779_();
                item.m_6787_(item.m_41471_(), list);
                return list.stream();
            }).collect(Collectors.toList());
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent combined = Component.m_237113_((String)"");
            combined.m_7220_((Component)Component.m_237113_((String)(((RequestTag)this.getRequest()).getCount() + " ")));
            String tagKey = "com.minecolonies.coremod.tag." + ((RequestTag)this.getRequest()).getTag().toString().toLowerCase().replace("namedtag[", "").replace(':', '.').replace("]", "");
            MutableComponent tagText = Component.m_237115_((String)tagKey);
            if (!tagText.m_214077_().equals(tagKey)) {
                combined.m_7220_((Component)Component.m_237113_((String)"#").m_7220_((Component)tagText));
            } else if (!this.stacks.isEmpty()) {
                combined.m_7220_((Component)Component.m_237113_((String)"#").m_7220_(this.stacks.get(0).m_41786_()));
            } else {
                combined.m_7220_((Component)Component.m_237113_((String)"#").m_7220_((Component)Component.m_237113_((String)((RequestTag)this.getRequest()).getTag().toString())));
            }
            return combined;
        }

        @Override
        public List<ItemStack> getDisplayStacks() {
            return Collections.unmodifiableList(this.stacks);
        }
    }

    public static class ItemStackListRequest
    extends AbstractRequest<StackList> {
        private ImmutableList<ItemStack> displayList;
        private StackList stackList;

        public ItemStackListRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull StackList requested) {
            super(requester, token, requested);
            this.displayList = ImmutableList.copyOf(requested.getStacks());
            this.stackList = requested;
        }

        public ItemStackListRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull StackList requested) {
            super(requester, token, state, requested);
            this.displayList = ImmutableList.copyOf(requested.getStacks());
            this.stackList = requested;
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent result = Component.m_237113_((String)"");
            result.m_7220_((Component)Component.m_237115_((String)this.stackList.getDescription()));
            return result;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            if (this.displayList.isEmpty()) {
                return ImmutableList.of();
            }
            return this.displayList;
        }
    }

    public static class ItemStackRequest
    extends AbstractRequest<Stack> {
        public ItemStackRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull Stack requested) {
            super(requester, token, requested);
        }

        public ItemStackRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull Stack requested) {
            super(requester, token, state, requested);
        }

        @Override
        @NotNull
        public Component getShortDisplayString() {
            MutableComponent combined = Component.m_237113_((String)"");
            if (((Stack)this.getRequest()).getMinimumCount() == ((Stack)this.getRequest()).getCount()) {
                combined.m_7220_((Component)Component.m_237113_((String)(((Stack)this.getRequest()).getCount() + " ")));
                combined.m_7220_(((Stack)this.getRequest()).getStack().m_41786_());
            } else {
                combined.m_7220_((Component)Component.m_237113_((String)(((Stack)this.getRequest()).getMinimumCount() + "-" + ((Stack)this.getRequest()).getCount() + " ")));
                combined.m_7220_(((Stack)this.getRequest()).getStack().m_41786_());
            }
            return combined;
        }

        @Override
        @NotNull
        public List<ItemStack> getDisplayStacks() {
            return ((Stack)this.getRequest()).getRequestedItems();
        }
    }
}

