/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StatisticsManager
implements IStatisticsManager {
    private static final String TAG_STAT_MANAGER = "stat_manager";
    private static final String TAG_STAT = "stat";
    private final IColony colony;
    private final Map<String, Int2IntLinkedOpenHashMap> stats = new HashMap<String, Int2IntLinkedOpenHashMap>();

    public StatisticsManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public void increment(@NotNull String id) {
        this.incrementBy(id, 1);
    }

    @Override
    public void incrementBy(@NotNull String id, int qty) {
        Int2IntLinkedOpenHashMap innerMap = this.stats.computeIfAbsent(id, k -> new Int2IntLinkedOpenHashMap());
        innerMap.addTo(this.colony.getDay(), qty);
    }

    @Override
    public int getStatTotal(@NotNull String id) {
        Int2IntLinkedOpenHashMap stats = this.stats.getOrDefault(id, new Int2IntLinkedOpenHashMap());
        int totalCount = 0;
        IntIterator intIterator = stats.values().iterator();
        while (intIterator.hasNext()) {
            int count = (Integer)intIterator.next();
            totalCount += count;
        }
        return totalCount;
    }

    @Override
    public int getStatsInPeriod(@NotNull String id, int startDay, int endDay) {
        Int2IntLinkedOpenHashMap stats = this.stats.getOrDefault(id, new Int2IntLinkedOpenHashMap());
        int count = 0;
        for (int day = startDay; day <= endDay; ++day) {
            count += stats.get(day);
        }
        return count;
    }

    @Override
    @NotNull
    public Set<String> getStatTypes() {
        return this.stats.keySet();
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        CompoundTag statsCompound = new CompoundTag();
        this.writeToNBT(statsCompound);
        buf.m_130079_(statsCompound);
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.readFromNBT(buf.m_130260_());
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag compound) {
        ListTag statManagerNBT = new ListTag();
        for (Map.Entry<String, Int2IntLinkedOpenHashMap> stat : this.stats.entrySet()) {
            CompoundTag statCompound = new CompoundTag();
            statCompound.m_128359_("id", stat.getKey());
            ListTag statNBT = new ListTag();
            for (Map.Entry dailyStats : stat.getValue().entrySet()) {
                CompoundTag timeStampTag = new CompoundTag();
                timeStampTag.m_128405_("time", ((Integer)dailyStats.getKey()).intValue());
                timeStampTag.m_128405_("quantity", ((Integer)dailyStats.getValue()).intValue());
                statNBT.add((Object)timeStampTag);
            }
            statCompound.m_128365_(TAG_STAT, (Tag)statNBT);
            statManagerNBT.add((Object)statCompound);
        }
        compound.m_128365_(TAG_STAT_MANAGER, (Tag)statManagerNBT);
    }

    @Override
    public void readFromNBT(@NotNull CompoundTag compound) {
        if (compound.m_128441_(TAG_STAT_MANAGER)) {
            ListTag statsNbts = compound.m_128437_(TAG_STAT_MANAGER, 10);
            for (int i = 0; i < statsNbts.size(); ++i) {
                CompoundTag statCompound = statsNbts.m_128728_(i);
                String id = statCompound.m_128461_("id");
                ListTag timeStampNbts = statCompound.m_128437_(TAG_STAT, 10);
                Int2IntLinkedOpenHashMap timeStamps = new Int2IntLinkedOpenHashMap();
                for (int j = 0; j < timeStampNbts.size(); ++j) {
                    CompoundTag compoundTag = timeStampNbts.m_128728_(j);
                    int day = compoundTag.m_128451_("time");
                    int qty = compoundTag.m_128451_("quantity");
                    timeStamps.put(day, qty);
                }
                this.stats.put(id, timeStamps);
            }
        }
    }
}

