/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableSet;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.modules.IAltersBuildingFootprint;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.FireworkUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSchematicProvider
implements ISchematicProvider,
IBuilding {
    protected final IColony colony;
    private final BlockPos location;
    private int buildingLevel = 0;
    private boolean isBuildingMirrored = false;
    private String structurePack = "Minecolonies Original";
    private String path = "";
    private int height;
    private BuildingEntry buildingType = null;
    private boolean isDeconstructed;
    private BlockPos lowerCorner = BlockPos.f_121853_;
    private BlockPos higherCorner = BlockPos.f_121853_;
    public int cachedRotation = -1;
    private BlockPos parentSchematic = BlockPos.f_121853_;
    private Set<BlockPos> childSchematics = ImmutableSet.of();
    private Future<Blueprint> blueprintFuture;

    public AbstractSchematicProvider(BlockPos pos, IColony colony) {
        this.location = pos;
        this.colony = colony;
    }

    public int hashCode() {
        return (int)(31L * this.getID().m_121878_());
    }

    public boolean equals(Object o) {
        return o instanceof AbstractBuilding && ((IBuilding)o).getID().equals((Object)this.getID());
    }

    @Override
    public boolean isDeconstructed() {
        return this.isDeconstructed;
    }

    @Override
    public void setDeconstructed() {
        this.isDeconstructed = true;
    }

    @Override
    public String getBlueprintPath() {
        return this.path;
    }

    @Override
    public void setBlueprintPath(String path) {
        this.path = path;
        this.getTileEntity().setBlueprintPath(path);
        this.cachedRotation = -1;
        this.markDirty();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        BlockPosUtil.write(compound, "location", this.location);
        compound.m_128359_("pack", this.structurePack);
        compound.m_128359_("path", this.getBlueprintPath());
        compound.m_128405_("level", this.buildingLevel);
        compound.m_128379_("mirror", this.isBuildingMirrored);
        this.getCorners();
        BlockPosUtil.write(compound, "corner1", this.lowerCorner);
        BlockPosUtil.write(compound, "corner2", this.higherCorner);
        compound.m_128405_("height", this.height);
        compound.m_128405_("rotation", this.getRotation());
        compound.m_128379_("deconstructed", this.isDeconstructed);
        BlockPosUtil.write(compound, "parent", this.parentSchematic);
        BlockPosUtil.writePosListToNBT(compound, "children", new ArrayList<BlockPos>(this.childSchematics));
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.buildingLevel = compound.m_128451_("level");
        this.deserializerStructureInformationFrom(compound);
        this.isBuildingMirrored = compound.m_128471_("mirror");
        if (compound.m_128431_().contains("corner1") && compound.m_128431_().contains("corner2")) {
            this.setCorners(BlockPosUtil.read(compound, "corner1"), BlockPosUtil.read(compound, "corner2"));
        }
        if (compound.m_128441_("height")) {
            this.height = compound.m_128451_("height");
        }
        if (compound.m_128441_("rotation")) {
            this.cachedRotation = compound.m_128451_("rotation");
        }
        this.isDeconstructed = compound.m_128441_("deconstructed") ? compound.m_128471_("deconstructed") : false;
        this.parentSchematic = BlockPosUtil.read(compound, "parent");
        this.childSchematics = ImmutableSet.copyOf(BlockPosUtil.readPosListFromNBT(compound, "children"));
    }

    private void deserializerStructureInformationFrom(CompoundTag compound) {
        Object path;
        String packName;
        if (compound.m_128441_("style") && !compound.m_128461_("style").isEmpty()) {
            packName = BlueprintMapping.getStyleMapping(compound.m_128461_("style"));
            path = BlueprintMapping.getPathMapping(compound.m_128461_("style"), this.getSchematicName()) + this.buildingLevel + ".blueprint";
        } else {
            packName = compound.m_128461_("pack");
            path = compound.m_128461_("path");
        }
        if (path == null || ((String)path).isEmpty()) {
            path = BlueprintMapping.getPathMapping("", this.getBuildingType().getBuildingBlock().getBlueprintName()) + "1.blueprint";
        }
        this.structurePack = packName;
        this.path = path;
        if (this.structurePack == null || this.structurePack.isEmpty()) {
            Log.getLogger().warn("Loaded empty style, setting to Default");
            this.structurePack = "Minecolonies Original";
        }
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    public void setCorners(BlockPos pos1, BlockPos pos2) {
        this.lowerCorner = new BlockPos(Math.min(pos1.m_123341_(), pos2.m_123341_()), Math.min(pos1.m_123342_(), pos2.m_123342_()), Math.min(pos1.m_123343_(), pos2.m_123343_()));
        this.higherCorner = new BlockPos(Math.max(pos1.m_123341_(), pos2.m_123341_()), Math.max(pos1.m_123342_(), pos2.m_123342_()), Math.max(pos1.m_123343_(), pos2.m_123343_()));
    }

    @Override
    public Tuple<BlockPos, BlockPos> getCorners() {
        if (this.lowerCorner == null || this.higherCorner == null) {
            this.calculateCorners();
        }
        return new Tuple((Object)this.lowerCorner, (Object)this.higherCorner);
    }

    @Override
    public BlockPos getID() {
        return this.location;
    }

    @Override
    public BlockPos getParent() {
        IBuilding building = this.colony.getBuildingManager().getBuilding(this.parentSchematic);
        if (building != null && !building.getChildren().contains(this.getID())) {
            building.addChild(this.getID());
        }
        return this.parentSchematic;
    }

    @Override
    public boolean hasParent() {
        return !this.parentSchematic.equals((Object)BlockPos.f_121853_);
    }

    @Override
    public void setParent(BlockPos pos) {
        if (!pos.equals((Object)this.getID())) {
            this.parentSchematic = pos;
        }
    }

    @Override
    public Set<BlockPos> getChildren() {
        IRegisteredStructureManager manager = this.colony.getBuildingManager();
        ArrayList<BlockPos> toRemove = null;
        for (BlockPos pos : this.childSchematics) {
            if (manager.getBuilding(pos) != null) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<BlockPos>();
            }
            toRemove.add(pos);
        }
        if (toRemove != null) {
            HashSet<BlockPos> oldPositions = new HashSet<BlockPos>(this.childSchematics);
            oldPositions.removeAll(toRemove);
            this.childSchematics = ImmutableSet.copyOf(oldPositions);
        }
        return this.childSchematics;
    }

    @Override
    public void addChild(BlockPos pos) {
        this.childSchematics = ImmutableSet.builder().addAll(this.childSchematics).add((Object)pos).build();
    }

    @Override
    public void removeChild(BlockPos pos) {
        HashSet<BlockPos> oldPositions = new HashSet<BlockPos>(this.childSchematics);
        oldPositions.remove(pos);
        this.childSchematics = ImmutableSet.copyOf(oldPositions);
    }

    @Override
    public int getRotation() {
        if (this.cachedRotation != -1) {
            return this.cachedRotation;
        }
        try {
            Blueprint blueprint = StructurePacks.getBlueprint((String)this.structurePack, (String)this.path, (boolean)true);
            if (blueprint == null && this.path.endsWith("0.blueprint")) {
                blueprint = StructurePacks.getBlueprint((String)this.structurePack, (String)this.path.replace("0.blueprint", "1.blueprint"), (boolean)true);
            }
            if (blueprint != null) {
                BlockState structureState = ((BlockInfo)blueprint.getBlockInfoAsMap().get(blueprint.getPrimaryBlockOffset())).getState();
                if (structureState != null) {
                    int worldRotation;
                    if (!(structureState.m_60734_() instanceof AbstractBlockHut) || !(this.colony.getWorld().m_8055_(this.location).m_60734_() instanceof AbstractBlockHut)) {
                        Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", this.path));
                        return 0;
                    }
                    int structureRotation = ((Direction)structureState.m_61143_((Property)AbstractBlockHut.FACING)).m_122416_();
                    this.cachedRotation = structureRotation <= (worldRotation = ((Direction)this.colony.getWorld().m_8055_(this.location).m_61143_((Property)AbstractBlockHut.FACING)).m_122416_()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
                    return this.cachedRotation;
                }
            } else {
                Log.getLogger().error(String.format("Failed to get rotation for %s: ", this.path));
            }
        }
        catch (Exception e) {
            Log.getLogger().error(String.format("Failed to get rotation for %s: ", this.path), (Throwable)e);
            return 0;
        }
        return 0;
    }

    public void safeUpdateTEDataFromSchematic() {
        if (this.buildingLevel <= 0 || this.blueprintFuture != null) {
            return;
        }
        TileEntityColonyBuilding te = (TileEntityColonyBuilding)this.colony.getWorld().m_7702_(this.getPosition());
        try {
            this.unsafeUpdateTEDataFromSchematic(te);
            return;
        }
        catch (Exception ex) {
            Log.getLogger().warn("TileEntity with invalid data, restoring correct data from schematic.");
            te.setSchematicName(this.getSchematicName() + Math.max(1, this.buildingLevel));
            try {
                this.unsafeUpdateTEDataFromSchematic(te);
            }
            catch (Exception ex2) {
                MessageUtils.format("com.minecolonies.coremod.invalidbuilding", this.getSchematicName(), this.getID().m_123341_(), this.getID().m_123342_(), this.getID().m_123343_(), this.getStructurePack()).sendTo(this.colony).forAllPlayers();
            }
            return;
        }
    }

    @Override
    public void onColonyTick(IColony colony) {
        if (this.blueprintFuture != null && this.blueprintFuture.isDone()) {
            try {
                Blueprint blueprint = this.blueprintFuture.get();
                if (blueprint != null) {
                    blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.getRotation()), this.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, colony.getWorld());
                    BlockInfo info = blueprint.getBlockInfoAsMap().getOrDefault(blueprint.getPrimaryBlockOffset(), null);
                    if (info.getTileEntityData() != null) {
                        CompoundTag teCompound = info.getTileEntityData().m_6426_();
                        teCompound.m_128359_("pack", blueprint.getPackName());
                        String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(blueprint.getFilePath().resolve(blueprint.getFileName()));
                        teCompound.m_128359_("name", location);
                        this.getTileEntity().readSchematicDataFromNBT(teCompound);
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private void unsafeUpdateTEDataFromSchematic(TileEntityColonyBuilding te) {
        String packName;
        String structureName;
        if (te.getSchematicName().isEmpty()) {
            structureName = this.path;
            packName = this.structurePack;
        } else {
            structureName = te.getBlueprintPath();
            packName = te.getStructurePack().getName();
        }
        this.blueprintFuture = StructurePacks.getBlueprintFuture((String)packName, (String)structureName);
    }

    @Override
    public String getStructurePack() {
        IBuilding building;
        if (this.parentSchematic != BlockPos.f_121853_ && (building = this.colony.getBuildingManager().getBuilding(this.parentSchematic)) != null) {
            return building.getStructurePack();
        }
        return this.structurePack;
    }

    @Override
    public void setStructurePack(String pack) {
        this.structurePack = pack;
        this.cachedRotation = -1;
        this.markDirty();
        this.getTileEntity().setStructurePack(StructurePacks.getStructurePack((String)pack));
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.isDeconstructed = false;
        this.buildingLevel = level;
        this.markDirty();
    }

    @Override
    public void setIsMirrored(boolean isMirrored) {
        this.isBuildingMirrored = isMirrored;
    }

    @Override
    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    @Override
    public boolean isInBuilding(@NotNull BlockPos positionVec) {
        Tuple<BlockPos, BlockPos> corners = this.getCorners();
        BlockPos cornerA = (BlockPos)corners.m_14418_();
        BlockPos cornerB = (BlockPos)corners.m_14419_();
        if (this.hasModule(IAltersBuildingFootprint.class)) {
            Tuple<BlockPos, BlockPos> extensions = ((IAltersBuildingFootprint)this.getFirstModuleOccurance(IAltersBuildingFootprint.class)).getAdditionalCorners();
            cornerA = cornerA.m_121955_((Vec3i)extensions.m_14418_());
            cornerB = cornerB.m_121955_((Vec3i)extensions.m_14419_());
        }
        return positionVec.m_123341_() >= cornerA.m_123341_() - 1 && positionVec.m_123341_() <= cornerB.m_123341_() + 1 && positionVec.m_123342_() >= cornerA.m_123342_() - 1 && positionVec.m_123342_() <= cornerB.m_123342_() + 1 && positionVec.m_123343_() >= cornerA.m_123343_() - 1 && positionVec.m_123343_() <= cornerB.m_123343_() + 1;
    }

    @Override
    public void upgradeBuildingLevelToSchematicData() {
        BlockEntity tileEntity = this.colony.getWorld().m_7702_(this.getID());
        if (tileEntity instanceof IBlueprintDataProviderBE) {
            IBlueprintDataProviderBE blueprintDataProvider = (IBlueprintDataProviderBE)tileEntity;
            if (blueprintDataProvider.getSchematicName().isEmpty()) {
                return;
            }
            this.setCorners((BlockPos)blueprintDataProvider.getInWorldCorners().m_14418_(), (BlockPos)blueprintDataProvider.getInWorldCorners().m_14419_());
            int level = 0;
            try {
                level = Integer.parseInt(blueprintDataProvider.getSchematicName().substring(blueprintDataProvider.getSchematicName().length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (level > 0 && level >= this.getBuildingLevel() && level <= this.getMaxBuildingLevel()) {
                if (level > this.getBuildingLevel()) {
                    FireworkUtils.spawnFireworksAtAABBCorners(this.getCorners(), this.colony.getWorld(), level);
                }
                this.setBuildingLevel(level);
                this.onUpgradeComplete(level);
            }
        }
    }

    @Override
    public void onUpgradeSchematicTo(String oldSchematic, String newSchematic, IBlueprintDataProviderBE blueprintDataProvider) {
        this.upgradeBuildingLevelToSchematicData();
    }

    @Override
    public final BuildingEntry getBuildingType() {
        return this.buildingType;
    }

    @Override
    public void setBuildingType(BuildingEntry buildingType) {
        this.buildingType = buildingType;
    }
}

