/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks.decorative;

import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockConstructionTape
extends AbstractBlockMinecoloniesConstructionTape<BlockConstructionTape> {
    private static final String BLOCK_NAME = "blockconstructiontape";

    public BlockConstructionTape() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60978_(0.0f).m_60910_().m_222994_());
        this.shapes = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return super.m_5940_(state, worldIn, pos, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] faces = context.m_6232_();
        return BlockConstructionTape.getPlacementState(super.m_5573_(context), (BlockGetter)context.m_43725_(), context.m_8083_(), faces[0].m_122416_() >= 0 ? faces[0] : faces[1]);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, Direction dir, BlockState state, LevelAccessor worldIn, @NotNull BlockPos currentPos, BlockPos pos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return BlockConstructionTape.getPlacementState(super.m_7417_(stateIn, dir, state, worldIn, currentPos, pos), (BlockGetter)worldIn, currentPos, (Direction)stateIn.m_61143_((Property)FACING));
    }

    public static BlockState getPlacementState(@Nullable BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        Fluid fluid = world.m_6425_(pos).m_76152_();
        List<Direction> connections = BlockConstructionTape.getConnections(world, pos, face, (Boolean)state.m_61143_((Property)CORNER));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(connections.contains(Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(connections.contains(Direction.EAST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(connections.contains(Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(connections.contains(Direction.WEST)))).m_61124_((Property)FACING, (Comparable)face)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.f_76193_));
    }

    public static List<Direction> getConnections(BlockGetter world, BlockPos pos, Direction face, boolean corner) {
        ArrayList<Direction> connections = new ArrayList<Direction>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!BlockConstructionTape.canConnect(world, pos, direction)) continue;
            connections.add(direction);
        }
        if (connections.size() == 0 || connections.size() == 1 && corner) {
            if (corner) {
                connections.clear();
                connections.add(face);
                connections.add(face.m_122427_());
            } else {
                connections.add(face.m_122434_() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST);
                connections.add(face.m_122434_() == Direction.Axis.X ? Direction.NORTH : Direction.WEST);
            }
        } else if (connections.size() == 1) {
            connections.add(((Direction)connections.get(0)).m_122424_());
        } else if (connections.size() == 3) {
            Direction stem = Direction.NORTH;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (connections.contains(direction)) continue;
                stem = direction.m_122424_();
            }
            if (BlockConstructionTape.canRemoveTStem(world, pos, stem)) {
                connections.remove(connections.indexOf(stem));
            }
        }
        return connections;
    }

    protected static boolean canConnect(BlockGetter world, BlockPos pos, Direction face) {
        return world.m_8055_(switch (face) {
            default -> pos.m_122012_();
            case Direction.EAST -> pos.m_122029_();
            case Direction.SOUTH -> pos.m_122019_();
            case Direction.WEST -> pos.m_122024_();
        }).m_60734_() instanceof BlockConstructionTape;
    }

    protected static boolean canRemoveTStem(BlockGetter world, BlockPos pos, Direction face) {
        BlockState neighbor = world.m_8055_(pos.m_121945_(face));
        switch (face) {
            case NORTH: {
                return (Boolean)neighbor.m_61143_((Property)NORTH) == false && (Boolean)neighbor.m_61143_((Property)EAST) != false && (Boolean)neighbor.m_61143_((Property)WEST) != false;
            }
            case EAST: {
                return (Boolean)neighbor.m_61143_((Property)EAST) == false && (Boolean)neighbor.m_61143_((Property)NORTH) != false && (Boolean)neighbor.m_61143_((Property)SOUTH) != false;
            }
            case SOUTH: {
                return (Boolean)neighbor.m_61143_((Property)SOUTH) == false && (Boolean)neighbor.m_61143_((Property)EAST) != false && (Boolean)neighbor.m_61143_((Property)WEST) != false;
            }
            case WEST: {
                return (Boolean)neighbor.m_61143_((Property)WEST) == false && (Boolean)neighbor.m_61143_((Property)NORTH) != false && (Boolean)neighbor.m_61143_((Property)SOUTH) != false;
            }
        }
        return false;
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    public void m_48792_(Level worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity blockEntity) {
        worldIn.m_46597_(pos, BlockConstructionTape.getPlacementState(fallingState, (BlockGetter)worldIn, pos, (Direction)fallingState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, FACING, CORNER, WATERLOGGED});
    }
}

