/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.handler;

import com.maciej916.maenchants.common.capabilities.player.IPlayerCapability;
import com.maciej916.maenchants.common.network.ModNetworking;
import com.maciej916.maenchants.common.network.packet.PacketMultiJumpDo;
import com.maciej916.maenchants.common.network.packet.PacketMultiJumpSync;
import com.maciej916.maenchants.common.registries.ModEnchantments;
import com.maciej916.maenchants.common.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.network.NetworkDirection;

public class HandlerMultiJump {
    public static void handlerPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_20096_()) {
            IPlayerCapability enchantsCap = PlayerUtil.getAliveEnchantsCapability(event.player);
            if (enchantsCap == null) {
                return;
            }
            enchantsCap.setMultiJump(0);
        }
    }

    public static void handlerLoggedIn(ServerPlayer player) {
        IPlayerCapability enchantsCap = PlayerUtil.getAliveEnchantsCapability((Player)player);
        if (enchantsCap == null) {
            return;
        }
        int jumps = enchantsCap.getMultiJump();
        if (jumps > 0) {
            ModNetworking.INSTANCE.sendTo((Object)new PacketMultiJumpSync(jumps), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private static void handlerJumpClient(Player player) {
        if (HandlerMultiJump.handlerJump(player)) {
            ModNetworking.INSTANCE.sendToServer((Object)new PacketMultiJumpDo());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlerKeyInput(Minecraft mc, InputEvent.Key event) {
        if (!mc.m_91302_() || mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        IPlayerCapability enchantsCap = PlayerUtil.getAliveEnchantsCapability((Player)mc.f_91074_);
        if (enchantsCap == null) {
            return;
        }
        boolean down = mc.f_91066_.f_92089_.m_90857_();
        if (down) {
            if (!enchantsCap.getMultiJumpSpace()) {
                enchantsCap.setMultiJumpSpace(true);
                HandlerMultiJump.handlerJumpClient((Player)mc.f_91074_);
            }
        } else {
            enchantsCap.setMultiJumpSpace(false);
        }
    }

    public static boolean handlerJump(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.FEET);
        int lvl = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.MULTI_JUMP.get()), (ItemStack)stack);
        if (lvl == 0 || !HandlerMultiJump.allowJump(player)) {
            return false;
        }
        IPlayerCapability enchantsCap = PlayerUtil.getAliveEnchantsCapability(player);
        if (enchantsCap == null) {
            return false;
        }
        int jumps = enchantsCap.getMultiJump();
        if (jumps < lvl) {
            enchantsCap.setMultiJump(++jumps);
            player.m_6135_();
            HandlerMultiJump.extraExhaustion(player);
            return true;
        }
        return false;
    }

    private static boolean allowJump(Player player) {
        boolean insideLiquid;
        if (player.m_6047_()) {
            return false;
        }
        boolean performingAction = player.m_20096_() || !player.m_20197_().isEmpty() || player.m_150110_().f_35935_ || player.m_150110_().f_35936_;
        boolean bl = insideLiquid = player.m_20069_() || player.m_20077_();
        if (performingAction || insideLiquid) {
            return false;
        }
        ItemStack itemstack = player.m_6844_(EquipmentSlot.CHEST);
        boolean fallFlyingReady = itemstack.m_41720_() == Items.f_42741_ && ElytraItem.m_41140_((ItemStack)itemstack);
        return !fallFlyingReady;
    }

    private static void extraExhaustion(Player player) {
        if (player.m_20142_()) {
            player.m_36399_(0.6f);
        } else {
            player.m_36399_(0.15f);
        }
    }
}

