/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Tooltip;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIcon
extends Pane {
    @Nullable
    private Entity entity;
    private int count = 1;
    private float yaw = 30.0f;
    private float pitch = -10.0f;
    private float headyaw = 0.0f;

    public EntityIcon() {
    }

    public EntityIcon(@NotNull PaneParams params) {
        super(params);
        String entityName = params.getString("entity");
        if (entityName != null) {
            this.setEntity(new ResourceLocation(entityName));
        }
        this.count = params.getInteger("count", this.count);
        this.yaw = params.getFloat("yaw", this.yaw);
        this.pitch = params.getFloat("pitch", this.pitch);
        this.headyaw = params.getFloat("head", this.headyaw);
    }

    public void setEntity(@NotNull ResourceLocation entityId) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
        if (entityType != null) {
            this.setEntity(entityType);
        } else {
            this.resetEntity();
        }
    }

    public void setEntity(@NotNull EntityType<?> type) {
        Entity entity = type.m_20615_((Level)this.mc.f_91073_);
        if (entity != null) {
            this.setEntity(entity);
        } else {
            this.resetEntity();
        }
    }

    public void setEntity(@NotNull Entity entity) {
        this.entity = entity;
        Pane pane = this.onHover;
        if (pane instanceof Tooltip) {
            Tooltip tooltip = (Tooltip)pane;
            tooltip.setText(this.entity.m_5446_());
        }
    }

    public void resetEntity() {
        this.entity = null;
        Pane pane = this.onHover;
        if (pane instanceof Tooltip) {
            Tooltip tooltip = (Tooltip)pane;
            tooltip.clearText();
        }
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        if (this.entity != null) {
            ms.m_85836_();
            ms.m_85837_((double)this.x, (double)this.y, -50.0);
            AABB bb = this.entity.m_20191_();
            float scale = (float)((double)this.getHeight() / bb.m_82376_() / 1.5);
            int cx = this.getWidth() / 2;
            int by = this.getHeight();
            int offsetY = 2;
            EntityIcon.drawEntity(ms, cx, by - 2, scale, this.headyaw, this.yaw, this.pitch, this.entity);
            if (this.count != 1) {
                String s = String.valueOf(this.count);
                ms.m_85837_((double)this.getWidth(), (double)this.getHeight(), 100.0);
                ms.m_85841_(0.75f, 0.75f, 0.75f);
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                Font font = this.mc.f_91062_;
                float f = -4 - this.mc.f_91062_.m_92895_(s);
                Objects.requireNonNull(this.mc.f_91062_);
                font.m_92811_(s, f, (float)(-9), 0xFFFFFF, true, ms.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
                buffer.m_109911_();
            }
            ms.m_85849_();
        }
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && this.entity != null) {
            PaneBuilders.tooltipBuilder().hoverPane(this).build().setText(this.entity.m_5446_());
        }
    }
}

