/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntityTicker;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface ITE<T extends BlockEntity>
extends EntityBlock {
    public Class<T> getTileEntityClass();

    public BlockEntityType<? extends T> getTileEntityType();

    default public void withTileEntityDo(BlockGetter world, BlockPos pos, Consumer<T> action) {
        this.getTileEntityOptional(world, pos).ifPresent(action);
    }

    default public InteractionResult onTileEntityUse(BlockGetter world, BlockPos pos, Function<T, InteractionResult> action) {
        return this.getTileEntityOptional(world, pos).map(action).orElse(InteractionResult.PASS);
    }

    public static void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState) {
        if (!blockState.m_155947_()) {
            return;
        }
        if (blockState.m_60713_(newBlockState.m_60734_()) && newBlockState.m_155947_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SmartTileEntity) {
            SmartTileEntity ste = (SmartTileEntity)blockEntity;
            ste.destroy();
        }
        level.m_46747_(pos);
    }

    default public Optional<T> getTileEntityOptional(BlockGetter world, BlockPos pos) {
        return Optional.ofNullable(this.getTileEntity(world, pos));
    }

    default public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return this.getTileEntityType().m_155264_(p_153215_, p_153216_);
    }

    default public <S extends BlockEntity> BlockEntityTicker<S> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<S> p_153214_) {
        if (SmartTileEntity.class.isAssignableFrom(this.getTileEntityClass())) {
            return new SmartTileEntityTicker();
        }
        return null;
    }

    @Nullable
    default public T getTileEntity(BlockGetter worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        Class<T> expectedClass = this.getTileEntityClass();
        if (tileEntity == null) {
            return null;
        }
        if (!expectedClass.isInstance(tileEntity)) {
            return null;
        }
        return (T)tileEntity;
    }
}

