/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.encased;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.relays.encased.SplitShaftTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class SplitShaftRenderer
extends KineticTileEntityRenderer {
    public SplitShaftRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        Block block = te.m_58900_().m_60734_();
        Direction.Axis boxAxis = ((IRotate)block).getRotationAxis(te.m_58900_());
        BlockPos pos = te.m_58899_();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.m_122434_();
            if (boxAxis != axis) continue;
            float offset = SplitShaftRenderer.getRotationOffsetForPosition(te, pos, axis);
            float angle = time * te.getSpeed() * 3.0f / 10.0f % 360.0f;
            float modifier = 1.0f;
            if (te instanceof SplitShaftTileEntity) {
                modifier = ((SplitShaftTileEntity)te).getRotationSpeedModifier(direction);
            }
            angle *= modifier;
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            SuperByteBuffer superByteBuffer = CachedBufferer.partialFacing(AllBlockPartials.SHAFT_HALF, te.m_58900_(), direction);
            SplitShaftRenderer.kineticRotationTransform(superByteBuffer, te, axis, angle, light);
            superByteBuffer.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
    }
}

