/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train.capability;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.WorldAttached;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;

public class CapabilityMinecartController
implements ICapabilitySerializable<CompoundTag> {
    public static WorldAttached<Map<UUID, MinecartController>> loadedMinecartsByUUID = new WorldAttached<Map>($ -> new HashMap());
    public static WorldAttached<Set<UUID>> loadedMinecartsWithCoupling = new WorldAttached<Set>($ -> new HashSet());
    static WorldAttached<List<AbstractMinecart>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    static WorldAttached<List<UUID>> queuedUnloads = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    public static Capability<MinecartController> MINECART_CONTROLLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MinecartController>(){});
    private final LazyOptional<MinecartController> cap;
    private MinecartController handler;

    public static void tick(Level world) {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((LevelAccessor)world);
        List<AbstractMinecart> queued = queuedAdditions.get((LevelAccessor)world);
        List<UUID> queuedRemovals = queuedUnloads.get((LevelAccessor)world);
        Set<UUID> cartsWithCoupling = loadedMinecartsWithCoupling.get((LevelAccessor)world);
        Set<UUID> keySet = carts.keySet();
        keySet.removeAll(queuedRemovals);
        cartsWithCoupling.removeAll(queuedRemovals);
        for (AbstractMinecart abstractMinecart : queued) {
            AbstractMinecart minecartEntity;
            MinecartController minecartController;
            UUID uniqueID = abstractMinecart.m_20148_();
            if (world.f_46443_ && carts.containsKey(uniqueID) && (minecartController = carts.get(uniqueID)) != null && (minecartEntity = minecartController.cart()) != null && minecartEntity.m_19879_() != abstractMinecart.m_19879_()) continue;
            cartsWithCoupling.remove(uniqueID);
            LazyOptional capability = abstractMinecart.getCapability(MINECART_CONTROLLER_CAPABILITY);
            MinecartController controller = (MinecartController)capability.orElse(null);
            capability.addListener((NonNullConsumer)new MinecartRemovalListener(world, abstractMinecart));
            carts.put(uniqueID, controller);
            capability.ifPresent(mc -> {
                if (mc.isLeadingCoupling()) {
                    cartsWithCoupling.add(uniqueID);
                }
            });
            if (world.f_46443_ || controller == null) continue;
            controller.sendData();
        }
        queuedRemovals.clear();
        queued.clear();
        for (Map.Entry entry : carts.entrySet()) {
            MinecartController controller = (MinecartController)entry.getValue();
            if (controller != null && controller.isPresent()) {
                controller.tick();
                continue;
            }
            toRemove.add((UUID)entry.getKey());
        }
        cartsWithCoupling.removeAll(toRemove);
        keySet.removeAll(toRemove);
    }

    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        ChunkPos chunkPos = event.getChunk().m_7697_();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get(event.getLevel());
        for (MinecartController minecartController : carts.values()) {
            AbstractMinecart cart;
            if (minecartController == null || !minecartController.isPresent() || !(cart = minecartController.cart()).m_146902_().equals((Object)chunkPos)) continue;
            queuedUnloads.get(event.getLevel()).add(cart.m_20148_());
        }
    }

    protected static void onCartRemoved(Level world, AbstractMinecart entity) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((LevelAccessor)world);
        List<UUID> unloads = queuedUnloads.get((LevelAccessor)world);
        UUID uniqueID = entity.m_20148_();
        if (!carts.containsKey(uniqueID) || unloads.contains(uniqueID)) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        CapabilityMinecartController.handleKilledMinecart(world, carts.get(uniqueID), entity.m_20182_());
    }

    protected static void handleKilledMinecart(Level world, MinecartController controller, Vec3 removedPos) {
        if (controller == null) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            AbstractMinecart cart;
            MinecartController next = CouplingHandler.getNextInCouplingChain(world, controller, forward);
            if (next == null || next == MinecartController.EMPTY) continue;
            next.removeConnection(!forward);
            if (controller.hasContraptionCoupling(forward) || (cart = next.cart()) == null) continue;
            Vec3 itemPos = cart.m_20182_().m_82549_(removedPos).m_82490_(0.5);
            ItemEntity itemEntity = new ItemEntity(world, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, AllItems.MINECART_COUPLING.asStack());
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
    }

    @Nullable
    public static MinecartController getIfPresent(Level world, UUID cartId) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((LevelAccessor)world);
        if (carts == null) {
            return null;
        }
        if (!carts.containsKey(cartId)) {
            return null;
        }
        return carts.get(cartId);
    }

    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        CapabilityMinecartController capability = new CapabilityMinecartController((AbstractMinecart)entity);
        ResourceLocation id = Create.asResource("minecart_controller");
        event.addCapability(id, (ICapabilityProvider)capability);
        event.addListener(() -> {
            if (capability.cap.isPresent()) {
                capability.cap.invalidate();
            }
        });
        queuedAdditions.get((LevelAccessor)entity.m_20193_()).add((AbstractMinecart)entity);
    }

    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        entity.getCapability(MINECART_CONTROLLER_CAPABILITY).ifPresent(MinecartController::sendData);
    }

    public CapabilityMinecartController(AbstractMinecart minecart) {
        this.handler = new MinecartController(minecart);
        this.cap = LazyOptional.of(() -> this.handler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == MINECART_CONTROLLER_CAPABILITY) {
            return this.cap.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.handler.deserializeNBT(nbt);
    }

    public static class MinecartRemovalListener
    implements NonNullConsumer<LazyOptional<MinecartController>> {
        private Level world;
        private AbstractMinecart cart;

        public MinecartRemovalListener(Level world, AbstractMinecart cart) {
            this.world = world;
            this.cart = cart;
        }

        public boolean equals(Object obj) {
            return obj instanceof MinecartRemovalListener;
        }

        public int hashCode() {
            return 100;
        }

        public void accept(LazyOptional<MinecartController> t) {
            CapabilityMinecartController.onCartRemoved(this.world, this.cart);
        }
    }
}

