/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;

public final class SideTowerCover
extends TwilightTemplateStructurePiece {
    private static final List<String> SMALL_COVERS = ImmutableList.of((Object)"cobbled_small");
    private static final List<String> MEDIUM_COVERS = ImmutableList.of((Object)"cobbled_medium");
    private static final List<String> LARGE_COVERS = ImmutableList.of((Object)"cobbled_large");
    private final int width;
    private final int thickness = 2;

    public SideTowerCover(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.CENTRAL_TO_SIDE_TOWER.get(), compoundTag, ctx, SideTowerCover.readSettings(compoundTag));
        this.width = compoundTag.m_128451_("width");
    }

    private SideTowerCover(StructureTemplateManager structureManager, Rotation rotation, String name, BlockPos startPosition, int width) {
        this(structureManager, TwilightForestMod.prefix("lich_tower/side_tower_covers/" + name), SideTowerCover.makeSettings(rotation), startPosition, width);
    }

    private SideTowerCover(StructureTemplateManager structureManager, ResourceLocation templateLocation, StructurePlaceSettings placeSettings, BlockPos startPosition, int width) {
        super((StructurePieceType)TFStructurePieceTypes.CENTRAL_TO_SIDE_TOWER.get(), 0, structureManager, templateLocation, placeSettings, startPosition);
        this.width = width;
    }

    public static SideTowerCover smallCover(StructureTemplateManager structureManager, Rotation rotation, BlockPos startPosition, RandomSource random) {
        return new SideTowerCover(structureManager, rotation, "small/" + (String)Util.m_214621_(SMALL_COVERS, (RandomSource)random), startPosition, 5);
    }

    public static SideTowerCover mediumCover(StructureTemplateManager structureManager, Rotation rotation, BlockPos startPosition, RandomSource random) {
        return new SideTowerCover(structureManager, rotation, "medium/" + (String)Util.m_214621_(MEDIUM_COVERS, (RandomSource)random), startPosition, 7);
    }

    public static SideTowerCover largeCover(StructureTemplateManager structureManager, Rotation rotation, BlockPos startPosition, RandomSource random) {
        return new SideTowerCover(structureManager, rotation, "large/" + (String)Util.m_214621_(LARGE_COVERS, (RandomSource)random), startPosition, 9);
    }

    protected void m_213704_(String pFunction, BlockPos pPos, ServerLevelAccessor pLevel, RandomSource pRandom, BoundingBox pSbb) {
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.m_183620_(ctx, structureTag);
        structureTag.m_128405_("width", this.width);
    }
}

