/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.material.Material;
import twilightforest.init.BiomeKeys;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastleDungeonEntranceComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleDungeonExitComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class FinalCastleDungeonRoom31Component
extends TowerWingComponent {
    public int level;

    public FinalCastleDungeonRoom31Component(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this((StructurePieceType)TFStructurePieceTypes.TFFCDunR31.get(), nbt);
    }

    public FinalCastleDungeonRoom31Component(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
    }

    public FinalCastleDungeonRoom31Component(StructurePieceType piece, TFLandmark feature, int i, int x, int y, int z, Direction direction, int level) {
        super(piece, feature, i, x, y, z);
        this.m_73519_(direction);
        this.spawnListIndex = 2;
        this.size = 31;
        this.height = 7;
        this.level = level;
        this.f_73383_ = feature.getComponentToAddBoundingBox(x, y, z, -15, 0, -15, this.size - 1, this.height - 1, this.size - 1, Direction.SOUTH);
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        int i;
        Rotation direction;
        int maxSpread;
        if (parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        int mySpread = this.m_73548_() - parent.m_73548_();
        int n = maxSpread = this.level == 1 ? 2 : 3;
        if (mySpread == maxSpread && !this.isExitBuildForLevel(parent)) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 8 && !this.isExitBuildForLevel(parent); ++i) {
                if (!this.addDungeonExit(list, rand, direction = direction.m_55952_(RotationUtil.ROTATIONS[i & 3]))) continue;
                this.setExitBuiltForLevel(parent, true);
            }
        }
        if (mySpread < maxSpread) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 12; ++i) {
                direction = direction.m_55952_(RotationUtil.ROTATIONS[i & 3]);
                this.addDungeonRoom(parent, list, rand, direction, this.level);
            }
        }
    }

    private boolean isExitBuildForLevel(StructurePiece parent) {
        if (parent instanceof FinalCastleDungeonEntranceComponent) {
            return ((FinalCastleDungeonEntranceComponent)parent).hasExit;
        }
        return false;
    }

    private void setExitBuiltForLevel(StructurePiece parent, boolean exit) {
        if (parent instanceof FinalCastleDungeonEntranceComponent) {
            ((FinalCastleDungeonEntranceComponent)parent).hasExit = exit;
        }
    }

    protected boolean addDungeonRoom(StructurePiece parent, StructurePieceAccessor list, RandomSource rand, Rotation rotation, int level) {
        rotation = rotation.m_55952_(this.f_73379_);
        BlockPos rc = this.getNewRoomCoords(rand, rotation);
        FinalCastleDungeonRoom31Component dRoom = new FinalCastleDungeonRoom31Component((StructurePieceType)TFStructurePieceTypes.TFFCDunR31.get(), this.getFeatureType(), this.f_73384_ + 1, rc.m_123341_(), rc.m_123342_(), rc.m_123343_(), rotation.m_55954_(Direction.SOUTH), level);
        BoundingBox largerBB = BoundingBoxUtils.clone(dRoom.m_73547_());
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            StructurePiece intersect = TFStructureComponentOld.findIntersectingExcluding(start.f_192778_, largerBB, this);
            if (intersect == null) {
                list.m_142679_((StructurePiece)dRoom);
                dRoom.m_214092_(parent, list, rand);
                return true;
            }
        }
        return false;
    }

    protected boolean addDungeonExit(StructurePieceAccessor list, RandomSource rand, Rotation rotation) {
        rotation = rotation.m_55952_(this.f_73379_);
        BlockPos rc = this.getNewRoomCoords(rand, rotation);
        FinalCastleDungeonExitComponent dRoom = new FinalCastleDungeonExitComponent(this.getFeatureType(), this.f_73384_ + 1, rc.m_123341_(), rc.m_123342_(), rc.m_123343_(), rotation.m_55954_(Direction.SOUTH), this.level);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            StructurePiece intersect = TFStructureComponentOld.findIntersectingExcluding(start.f_192778_, dRoom.m_73547_(), this);
            if (intersect == null) {
                list.m_142679_((StructurePiece)dRoom);
                dRoom.m_214092_(this, list, rand);
                return true;
            }
        }
        return false;
    }

    private BlockPos getNewRoomCoords(RandomSource rand, Rotation rotation) {
        int offset = rand.m_188503_(15) - 9;
        if (rand.m_188499_()) {
            offset += this.size;
        }
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new BlockPos(this.f_73383_.m_162395_() + offset, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 9);
            case Rotation.CLOCKWISE_180 -> new BlockPos(this.f_73383_.m_162395_() - 9, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + offset);
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(this.f_73383_.m_162395_() + offset, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 9);
            default -> new BlockPos(this.f_73383_.m_162399_() + 9, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + offset);
        };
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        Predicate<Biome> plateauBiomes = biome -> biome == world.m_5962_().m_206191_(Registry.f_122885_).m_6246_(BiomeKeys.THORNLANDS) || biome == world.m_5962_().m_206191_(Registry.f_122885_).m_6246_(BiomeKeys.FINAL_PLATEAU);
        if (this.isBoundingBoxOutsideBiomes(world, plateauBiomes)) {
            return;
        }
        RandomSource decoRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L));
        this.fillWithAir(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, state -> state.m_60767_() == Material.f_76278_);
        BlockState floor = ((Block)TFBlocks.CASTLE_BRICK.get()).m_49966_();
        BlockState border = ((Block)TFBlocks.THICK_CASTLE_BRICK.get()).m_49966_();
        Predicate<BlockState> replacing = state -> {
            Material material = state.m_60767_();
            return material == Material.f_76278_ || material == Material.f_76296_;
        };
        int cs = 7;
        this.fillWithBlocks(world, sbb, 7, -1, 7, this.size - 1 - 7, -1, this.size - 1 - 7, border, floor, replacing);
        this.fillWithBlocks(world, sbb, 7, this.height, 7, this.size - 1 - 7, this.height, this.size - 1 - 7, border, floor, replacing);
        BlockState forceField = this.getForceFieldColor(decoRNG);
        BlockState castleMagic = this.getRuneColor(forceField);
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            this.fillBlocksRotated(world, sbb, 7, 0, 8, 7, this.height - 1, this.size - 2 - 7, forceField, rotation);
            for (int z = 7; z < this.size - 1 - 7; z += 4) {
                this.fillBlocksRotated(world, sbb, 7, 0, z, 7, this.height - 1, z, castleMagic, rotation);
                int y = (z - 7) % 8 == 0 ? decoRNG.m_188503_(3) : decoRNG.m_188503_(3) + 4;
                this.fillBlocksRotated(world, sbb, 7, y, z + 1, 7, y, z + 3, castleMagic, rotation);
            }
        }
    }

    protected BlockState getRuneColor(BlockState forceFieldColor) {
        return forceFieldColor.m_60713_((Block)TFBlocks.GREEN_FORCE_FIELD.get()) ? ((Block)TFBlocks.YELLOW_CASTLE_RUNE_BRICK.get()).m_49966_() : ((Block)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get()).m_49966_();
    }

    protected BlockState getForceFieldColor(RandomSource decoRNG) {
        int i = decoRNG.m_188503_(2) + 3;
        if (i == 3) {
            return ((Block)TFBlocks.GREEN_FORCE_FIELD.get()).m_49966_();
        }
        return ((Block)TFBlocks.BLUE_FORCE_FIELD.get()).m_49966_();
    }
}

