/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.floatingcarpet;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.recipes.RecipeIngredientJson;
import com.ldtteam.datagenerators.recipes.RecipeIngredientKeyJson;
import com.ldtteam.datagenerators.recipes.RecipeResultJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedPatternJson;
import com.ldtteam.datagenerators.recipes.shaped.ShapedRecipeJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FloatingCarpetRecipeProvider
implements DataProvider {
    private final DataGenerator generator;

    public FloatingCarpetRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        for (FloatingCarpetBlock block : ModBlocks.getInstance().getFloatingCarpets()) {
            DyeColor color = block.getColor();
            ShapedPatternJson pattern = new ShapedPatternJson("C  ", "S  ", "   ");
            HashMap<String, RecipeIngredientKeyJson> keys = new HashMap<String, RecipeIngredientKeyJson>();
            keys.put("C", new RecipeIngredientKeyJson(new RecipeIngredientJson("minecraft:" + color.m_41065_() + "_carpet", false)));
            keys.put("S", new RecipeIngredientKeyJson(new RecipeIngredientJson(Tags.Items.STRING.f_203868_().toString(), true)));
            ShapedRecipeJson json = new ShapedRecipeJson("floating_carpets", pattern, keys, new RecipeResultJson(4, ForgeRegistries.ITEMS.getKey((Object)block.m_5456_()).toString()));
            Path recipeFolder = this.generator.m_123916_().resolve("data/domum_ornamentum//recipes/");
            Path blockstatePath = recipeFolder.resolve(block.getRegistryName().m_135815_() + ".json");
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)json), (Path)blockstatePath);
        }
    }

    @NotNull
    public String m_6055_() {
        return "Floating Carpet Recipe Provider";
    }
}

