/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import com.google.common.collect.ArrayListMultimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import vazkii.arl.AutoRegLib;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.interf.IItemPropertiesFiller;

public final class RegistryHelper {
    private static final Map<String, ModData> modData = new HashMap<String, ModData>();
    private static final Queue<Pair<Item, IItemColorProvider>> itemColors = new ArrayDeque<Pair<Item, IItemColorProvider>>();
    private static final Queue<Pair<Block, IBlockColorProvider>> blockColors = new ArrayDeque<Pair<Block, IBlockColorProvider>>();
    private static final Map<Object, ResourceLocation> internalNames = new HashMap<Object, ResourceLocation>();

    private static ModData getCurrentModData() {
        return RegistryHelper.getModData(ModLoadingContext.get().getActiveNamespace());
    }

    private static ModData getModData(String modid) {
        ModData data = modData.get(modid);
        if (data == null) {
            data = new ModData();
            modData.put(modid, data);
            FMLJavaModLoadingContext.get().getModEventBus().register(RegistryHelper.class);
        }
        return data;
    }

    public static <T> ResourceLocation getRegistryName(T obj, Registry<T> registry) {
        if (internalNames.containsKey(obj)) {
            return RegistryHelper.getInternalName(obj);
        }
        return registry.m_7981_(obj);
    }

    public static void setInternalName(Object obj, ResourceLocation name) {
        internalNames.put(obj, name);
    }

    public static ResourceLocation getInternalName(Object obj) {
        return internalNames.get(obj);
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegisterEvent event) {
        RegistryHelper.getCurrentModData().register(event.getRegistryKey(), event.getForgeRegistry());
    }

    public static void registerBlock(Block block, String resloc) {
        RegistryHelper.registerBlock(block, resloc, true);
    }

    public static void registerBlock(Block block, String resloc, boolean hasBlockItem) {
        RegistryHelper.register(block, resloc, Registry.f_122901_);
        if (hasBlockItem) {
            ModData data = RegistryHelper.getCurrentModData();
            data.defers.put((Object)Registry.f_122904_.m_135782_(), () -> data.createItemBlock(block));
        }
        if (block instanceof IBlockColorProvider) {
            blockColors.add((Pair<Block, IBlockColorProvider>)Pair.of((Object)block, (Object)((IBlockColorProvider)block)));
        }
    }

    public static void registerItem(Item item, String resloc) {
        RegistryHelper.register(item, resloc, Registry.f_122904_);
        if (item instanceof IItemColorProvider) {
            itemColors.add((Pair<Item, IItemColorProvider>)Pair.of((Object)item, (Object)((IItemColorProvider)item)));
        }
    }

    public static <T> void register(T obj, String resloc, ResourceKey<Registry<T>> registry) {
        if (obj == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        RegistryHelper.setInternalName(obj, GameData.checkPrefix((String)resloc, (boolean)false));
        RegistryHelper.getCurrentModData().defers.put((Object)registry.m_135782_(), () -> obj);
    }

    public static <T> void register(T obj, ResourceKey<Registry<T>> registry) {
        if (obj == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        if (RegistryHelper.getInternalName(obj) == null) {
            throw new IllegalArgumentException("Can't register object without registry name.");
        }
        RegistryHelper.getCurrentModData().defers.put((Object)registry.m_135782_(), () -> obj);
    }

    public static void setCreativeTab(Block block, CreativeModeTab group) {
        ResourceLocation res = RegistryHelper.getInternalName(block);
        if (res == null) {
            throw new IllegalArgumentException("Can't set the creative tab for a block without a registry name yet");
        }
        RegistryHelper.getCurrentModData().groups.put(res, group);
    }

    public static void submitBlockColors(BiConsumer<BlockColor, Block> consumer) {
        blockColors.forEach(p -> consumer.accept(((IBlockColorProvider)p.getSecond()).getBlockColor(), (Block)p.getFirst()));
        blockColors.clear();
    }

    public static void submitItemColors(BiConsumer<ItemColor, Item> consumer) {
        itemColors.forEach(p -> consumer.accept(((IItemColorProvider)p.getSecond()).getItemColor(), (Item)p.getFirst()));
        itemColors.clear();
    }

    private static class ModData {
        private Map<ResourceLocation, CreativeModeTab> groups = new LinkedHashMap<ResourceLocation, CreativeModeTab>();
        private ArrayListMultimap<ResourceLocation, Supplier<Object>> defers = ArrayListMultimap.create();

        private ModData() {
        }

        private <T> void register(ResourceKey<? extends Registry<?>> key, IForgeRegistry<T> registry) {
            ResourceLocation registryRes = key.m_135782_();
            if (this.defers.containsKey((Object)registryRes)) {
                if (registry == null) {
                    AutoRegLib.LOGGER.error(registryRes + " does not have a forge registry");
                    return;
                }
                List ourEntries = this.defers.get((Object)registryRes);
                for (Supplier supplier : ourEntries) {
                    Object entry = supplier.get();
                    ResourceLocation name = RegistryHelper.getInternalName(entry);
                    registry.register(name, entry);
                    AutoRegLib.LOGGER.debug("Registering to " + registryRes + " - " + name);
                }
                this.defers.removeAll((Object)registryRes);
            }
        }

        private Item createItemBlock(Block block) {
            Item.Properties props = new Item.Properties();
            ResourceLocation registryName = RegistryHelper.getInternalName(block);
            CreativeModeTab group = this.groups.get(registryName);
            if (group != null) {
                props = props.m_41491_(group);
            }
            if (block instanceof IItemPropertiesFiller) {
                ((IItemPropertiesFiller)block).fillItemProperties(props);
            }
            BlockItem blockitem = block instanceof IBlockItemProvider ? ((IBlockItemProvider)block).provideItemBlock(block, props) : new BlockItem(block, props);
            if (block instanceof IItemColorProvider) {
                itemColors.add((Pair<Item, IItemColorProvider>)Pair.of((Object)blockitem, (Object)((IItemColorProvider)block)));
            }
            RegistryHelper.setInternalName(blockitem, registryName);
            return blockitem;
        }
    }
}

