/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.api.Upgrade;
import mekanism.api.functions.TriConsumer;
import mekanism.api.security.SecurityMode;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.entity.robit.MainRobitContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityDimensionalStabilizer;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.qio.TileEntityQIOExporter;
import mekanism.common.tile.qio.TileEntityQIOImporter;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkEvent;

public class PacketGuiInteract
implements IMekanismPacket {
    private final Type interactionType;
    private GuiInteraction interaction;
    private GuiInteractionItem itemInteraction;
    private GuiInteractionEntity entityInteraction;
    private BlockPos tilePosition;
    private ItemStack extraItem;
    private int entityID;
    private int extra;

    public PacketGuiInteract(GuiInteractionEntity interaction, Entity entity) {
        this(interaction, entity, 0);
    }

    public PacketGuiInteract(GuiInteractionEntity interaction, Entity entity, int extra) {
        this(interaction, entity.m_19879_(), extra);
    }

    public PacketGuiInteract(GuiInteractionEntity interaction, int entityID, int extra) {
        this.interactionType = Type.ENTITY;
        this.entityInteraction = interaction;
        this.entityID = entityID;
        this.extra = extra;
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.m_58899_());
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockEntity tile, int extra) {
        this(interaction, tile.m_58899_(), extra);
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interactionType = Type.INT;
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public PacketGuiInteract(GuiInteractionItem interaction, BlockEntity tile, ItemStack stack) {
        this(interaction, tile.m_58899_(), stack);
    }

    public PacketGuiInteract(GuiInteractionItem interaction, BlockPos tilePosition, ItemStack stack) {
        this.interactionType = Type.ITEM;
        this.itemInteraction = interaction;
        this.tilePosition = tilePosition;
        this.extraItem = stack;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            if (this.interactionType == Type.ENTITY) {
                Entity entity = player.f_19853_.m_6815_(this.entityID);
                if (entity != null) {
                    this.entityInteraction.consume(entity, (Player)player, this.extra);
                }
            } else {
                TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.f_19853_, this.tilePosition);
                if (tile != null) {
                    if (this.interactionType == Type.INT) {
                        this.interaction.consume(tile, (Player)player, this.extra);
                    } else if (this.interactionType == Type.ITEM) {
                        this.itemInteraction.consume(tile, (Player)player, this.extraItem);
                    }
                }
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.interactionType);
        switch (this.interactionType) {
            case ENTITY: {
                buffer.m_130068_((Enum)this.entityInteraction);
                buffer.m_130130_(this.entityID);
                buffer.m_130130_(this.extra);
                break;
            }
            case INT: {
                buffer.m_130068_((Enum)this.interaction);
                buffer.m_130064_(this.tilePosition);
                buffer.m_130130_(this.extra);
                break;
            }
            case ITEM: {
                buffer.m_130068_((Enum)this.itemInteraction);
                buffer.m_130064_(this.tilePosition);
                buffer.m_130055_(this.extraItem);
            }
        }
    }

    public static PacketGuiInteract decode(FriendlyByteBuf buffer) {
        return switch ((Type)buffer.m_130066_(Type.class)) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ENTITY -> new PacketGuiInteract((GuiInteractionEntity)buffer.m_130066_(GuiInteractionEntity.class), buffer.m_130242_(), buffer.m_130242_());
            case Type.INT -> new PacketGuiInteract((GuiInteraction)buffer.m_130066_(GuiInteraction.class), buffer.m_130135_(), buffer.m_130242_());
            case Type.ITEM -> new PacketGuiInteract((GuiInteractionItem)buffer.m_130066_(GuiInteractionItem.class), buffer.m_130135_(), buffer.m_130267_());
        };
    }

    public static enum GuiInteractionEntity {
        NEXT_SECURITY_MODE((entity, player, extra) -> SecurityUtils.INSTANCE.incrementSecurityMode((Player)player, (ICapabilityProvider)entity)),
        CONTAINER_STOP_TRACKING((entity, player, extra) -> {
            AbstractContainerMenu patt17285$temp = player.f_36096_;
            if (patt17285$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt17285$temp;
                container.stopTracking(extra);
            }
        }),
        CONTAINER_TRACK_SKIN_SELECT((entity, player, extra) -> {
            AbstractContainerMenu patt17502$temp = player.f_36096_;
            if (patt17502$temp instanceof MainRobitContainer) {
                MainRobitContainer container = (MainRobitContainer)patt17502$temp;
                container.startTracking(extra, container);
            }
        });

        private final TriConsumer<Entity, Player, Integer> consumerForEntity;

        private GuiInteractionEntity(TriConsumer<Entity, Player, Integer> consumerForEntity) {
            this.consumerForEntity = consumerForEntity;
        }

        public void consume(Entity entity, Player player, int extra) {
            this.consumerForEntity.accept(entity, player, extra);
        }
    }

    private static enum Type {
        ENTITY,
        ITEM,
        INT;

    }

    public static enum GuiInteraction {
        CONTAINER_STOP_TRACKING((tile, player, extra) -> {
            AbstractContainerMenu patt7356$temp = player.f_36096_;
            if (patt7356$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt7356$temp;
                container.stopTracking(extra);
            }
        }),
        CONTAINER_TRACK_EJECTOR((tile, player, extra) -> {
            AbstractContainerMenu patt7567$temp = player.f_36096_;
            if (patt7567$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt7567$temp;
                if (tile instanceof ISideConfiguration) {
                    ISideConfiguration sideConfig = (ISideConfiguration)((Object)tile);
                    container.startTracking(extra, sideConfig.getEjector());
                }
            }
        }),
        CONTAINER_TRACK_SIDE_CONFIG((tile, player, extra) -> {
            AbstractContainerMenu patt7857$temp = player.f_36096_;
            if (patt7857$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt7857$temp;
                if (tile instanceof ISideConfiguration) {
                    ISideConfiguration sideConfig = (ISideConfiguration)((Object)tile);
                    container.startTracking(extra, sideConfig.getConfig());
                }
            }
        }),
        CONTAINER_TRACK_UPGRADES((tile, player, extra) -> {
            AbstractContainerMenu patt8143$temp = player.f_36096_;
            if (patt8143$temp instanceof MekanismContainer) {
                MekanismContainer container = (MekanismContainer)patt8143$temp;
                container.startTracking(extra, tile.getComponent());
            }
        }),
        QIO_REDSTONE_ADAPTER_COUNT((tile, player, extra) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                TileEntityQIORedstoneAdapter redstoneAdapter = (TileEntityQIORedstoneAdapter)tile;
                redstoneAdapter.handleCountChange(extra.intValue());
            }
        }),
        QIO_REDSTONE_ADAPTER_FUZZY((tile, player, extra) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                TileEntityQIORedstoneAdapter redstoneAdapter = (TileEntityQIORedstoneAdapter)tile;
                redstoneAdapter.toggleFuzzyMode();
            }
        }),
        QIO_TOGGLE_IMPORT_WITHOUT_FILTER((tile, player, extra) -> {
            if (tile instanceof TileEntityQIOImporter) {
                TileEntityQIOImporter importer = (TileEntityQIOImporter)tile;
                importer.toggleImportWithoutFilter();
            }
        }),
        QIO_TOGGLE_EXPORT_WITHOUT_FILTER((tile, player, extra) -> {
            if (tile instanceof TileEntityQIOExporter) {
                TileEntityQIOExporter exporter = (TileEntityQIOExporter)tile;
                exporter.toggleExportWithoutFilter();
            }
        }),
        AUTO_SORT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityFactory) {
                TileEntityFactory factory = (TileEntityFactory)tile;
                factory.toggleSorting();
            }
        }),
        DUMP_BUTTON((tile, player, extra) -> {
            if (tile instanceof IHasDumpButton) {
                IHasDumpButton hasDumpButton = (IHasDumpButton)((Object)tile);
                hasDumpButton.dump();
            }
        }),
        GAS_MODE_BUTTON((tile, player, extra) -> {
            if (tile instanceof IHasGasMode) {
                IHasGasMode hasGasMode = (IHasGasMode)((Object)tile);
                hasGasMode.nextMode((int)extra);
            }
        }),
        AUTO_EJECT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleAutoEject();
            } else if (tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                sorter.toggleAutoEject();
            }
        }),
        AUTO_PULL_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleAutoPull();
            }
        }),
        INVERSE_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleInverse();
            }
        }),
        INVERSE_REQUIRES_REPLACEMENT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleInverseRequiresReplacement();
            }
        }),
        RESET_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.reset();
            }
        }),
        SILK_TOUCH_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.toggleSilkTouch();
            }
        }),
        START_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.start();
            }
        }),
        STOP_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.stop();
            }
        }),
        SET_RADIUS((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setRadiusFromPacket((int)extra);
            }
        }),
        SET_MIN_Y((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setMinYFromPacket((int)extra);
            }
        }),
        SET_MAX_Y((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setMaxYFromPacket((int)extra);
            }
        }),
        MOVE_FILTER_UP((tile, player, extra) -> {
            ITileFilterHolder filterHolder;
            FilterManager patt12013$temp;
            if (tile instanceof ITileFilterHolder && (patt12013$temp = (filterHolder = (ITileFilterHolder)((Object)tile)).getFilterManager()) instanceof SortableFilterManager) {
                SortableFilterManager manager = (SortableFilterManager)patt12013$temp;
                manager.moveUp((int)extra);
            }
        }),
        MOVE_FILTER_DOWN((tile, player, extra) -> {
            ITileFilterHolder filterHolder;
            FilterManager patt12278$temp;
            if (tile instanceof ITileFilterHolder && (patt12278$temp = (filterHolder = (ITileFilterHolder)((Object)tile)).getFilterManager()) instanceof SortableFilterManager) {
                SortableFilterManager manager = (SortableFilterManager)patt12278$temp;
                manager.moveDown((int)extra);
            }
        }),
        TOGGLE_FILTER_STATE((tile, player, extra) -> {
            if (tile instanceof ITileFilterHolder) {
                ITileFilterHolder filterHolder = (ITileFilterHolder)((Object)tile);
                filterHolder.getFilterManager().toggleState((int)extra);
            }
        }),
        REMOVE_UPGRADE((tile, player, extra) -> {
            if (tile.supportsUpgrades()) {
                tile.getComponent().removeUpgrade(Upgrade.byIndexStatic(extra), false);
            }
        }),
        REMOVE_ALL_UPGRADE((tile, player, extra) -> {
            if (tile.supportsUpgrades()) {
                tile.getComponent().removeUpgrade(Upgrade.byIndexStatic(extra), true);
            }
        }),
        NEXT_SECURITY_MODE((tile, player, extra) -> SecurityUtils.INSTANCE.incrementSecurityMode((Player)player, (ICapabilityProvider)tile)),
        SECURITY_DESK_MODE((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                TileEntitySecurityDesk desk = (TileEntitySecurityDesk)tile;
                desk.setSecurityDeskMode(SecurityMode.byIndexStatic(extra));
            }
        }),
        NEXT_MODE((tile, player, extra) -> {
            if (tile instanceof IHasMode) {
                IHasMode hasMode = (IHasMode)((Object)tile);
                hasMode.nextMode();
            }
        }),
        NEXT_REDSTONE_CONTROL((tile, player, extra) -> tile.setControlType(tile.getControlType().getNext(mode -> mode != IRedstoneControl.RedstoneControl.PULSE || tile.canPulse()))),
        ENCODE_FORMULA((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.encodeFormula();
            }
        }),
        STOCK_CONTROL_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.toggleStockControl();
            }
        }),
        CRAFT_SINGLE((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.craftSingle();
            }
        }),
        CRAFT_ALL((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.craftAll();
            }
        }),
        MOVE_ITEMS((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                TileEntityFormulaicAssemblicator assemblicator = (TileEntityFormulaicAssemblicator)tile;
                assemblicator.moveItems();
            }
        }),
        ROUND_ROBIN_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                sorter.toggleRoundRobin();
            }
        }),
        SINGLE_ITEM_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                sorter.toggleSingleItem();
            }
        }),
        CHANGE_COLOR((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
                sorter.changeColor(TransporterUtils.readColor(extra));
            }
        }),
        OVERRIDE_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                TileEntitySecurityDesk desk = (TileEntitySecurityDesk)tile;
                desk.toggleOverride();
            }
        }),
        REMOVE_TRUSTED((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                TileEntitySecurityDesk desk = (TileEntitySecurityDesk)tile;
                desk.removeTrusted((int)extra);
            }
        }),
        SET_TIME((tile, player, extra) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                TileEntityLaserAmplifier amplifier = (TileEntityLaserAmplifier)tile;
                amplifier.setDelay((int)extra);
            }
        }),
        TOGGLE_CHUNKLOAD((tile, player, extra) -> {
            if (tile instanceof TileEntityDimensionalStabilizer) {
                TileEntityDimensionalStabilizer stabilizer = (TileEntityDimensionalStabilizer)tile;
                stabilizer.toggleChunkLoadingAt(extra / 5, extra % 5);
            }
        }),
        ENABLE_RADIUS_CHUNKLOAD((tile, player, extra) -> {
            if (tile instanceof TileEntityDimensionalStabilizer) {
                TileEntityDimensionalStabilizer stabilizer = (TileEntityDimensionalStabilizer)tile;
                stabilizer.adjustChunkLoadingRadius((int)extra, true);
            }
        }),
        DISABLE_RADIUS_CHUNKLOAD((tile, player, extra) -> {
            if (tile instanceof TileEntityDimensionalStabilizer) {
                TileEntityDimensionalStabilizer stabilizer = (TileEntityDimensionalStabilizer)tile;
                stabilizer.adjustChunkLoadingRadius((int)extra, false);
            }
        });

        private final TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile;

        private GuiInteraction(TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, int extra) {
            this.consumerForTile.accept(tile, player, extra);
        }
    }

    public static enum GuiInteractionItem {
        DIGITAL_MINER_INVERSE_REPLACE_ITEM((tile, player, stack) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tile;
                miner.setInverseReplaceTarget(stack.m_41720_());
            }
        }),
        QIO_REDSTONE_ADAPTER_STACK((tile, player, stack) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                TileEntityQIORedstoneAdapter redstoneAdapter = (TileEntityQIORedstoneAdapter)tile;
                redstoneAdapter.handleStackChange((ItemStack)stack);
            }
        });

        private final TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile;

        private GuiInteractionItem(TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, ItemStack stack) {
            this.consumerForTile.accept(tile, player, stack);
        }
    }
}

