/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedHashMap;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.computercraft.CCMethodCaller;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MekanismPeripheral<TILE extends BlockEntity>
extends CCMethodCaller
implements IDynamicPeripheral {
    private final String name;
    private final TILE tile;

    public static <TILE extends BlockEntity> MekanismPeripheral<TILE> create(TILE tile) {
        LinkedHashMap<String, BoundComputerMethod> boundMethods = new LinkedHashMap<String, BoundComputerMethod>();
        ((IComputerTile)tile).getComputerMethods(boundMethods);
        return new MekanismPeripheral<TILE>(tile, boundMethods);
    }

    private MekanismPeripheral(TILE tile, Map<String, BoundComputerMethod> boundMethods) {
        super(boundMethods);
        this.tile = tile;
        this.name = ((IComputerTile)this.tile).getComputerName();
    }

    @Override
    protected String getCallerType() {
        return "peripheral";
    }

    public String getType() {
        return this.name;
    }

    public Object getTarget() {
        return this.tile;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this;
    }

    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int methodIndex, IArguments arguments) throws LuaException {
        return this.callMethod(context, methodIndex, arguments);
    }
}

