/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.function.Supplier;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.lib.effect.CustomEffect;
import net.minecraft.client.Camera;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;

public class BillboardingEffectRenderer {
    private BillboardingEffectRenderer() {
    }

    public static void render(CustomEffect effect, String profilerSection) {
        BillboardingEffectRenderer.render(effect.getTexture(), profilerSection, () -> effect);
    }

    public static void render(ResourceLocation texture, final String profilerSection, final Supplier<CustomEffect> lazyEffect) {
        RenderTickHandler.addTransparentRenderer(MekanismRenderType.SPS.apply(texture), new RenderTickHandler.LazyRender(){

            @Override
            public void render(Camera camera, VertexConsumer renderer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
                BillboardingEffectRenderer.render(camera, renderer, poseStack, renderTick, partialTick, (CustomEffect)lazyEffect.get());
            }

            @Override
            public Vec3 getCenterPos(float partialTick) {
                return ((CustomEffect)lazyEffect.get()).getPos(partialTick);
            }

            @Override
            public String getProfilerSection() {
                return profilerSection;
            }
        });
    }

    private static void render(Camera camera, VertexConsumer buffer, PoseStack poseStack, int renderTick, float partialTick, CustomEffect effect) {
        int gridSize = effect.getTextureGridSize();
        int tick = renderTick % (gridSize * gridSize);
        int xIndex = tick % gridSize;
        int yIndex = tick / gridSize;
        float spriteSize = 1.0f / (float)gridSize;
        Quaternion quaternion = camera.m_90591_();
        Vector3f[] vertexPos = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        Vec3 pos = effect.getPos(partialTick);
        for (Vector3f vector3f : vertexPos) {
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(effect.getScale());
            vector3f.m_122272_((float)pos.m_7096_(), (float)pos.m_7098_(), (float)pos.m_7094_());
        }
        int[] color = effect.getColor().rgbaArray();
        float minU = (float)xIndex * spriteSize;
        float maxU = minU + spriteSize;
        float minV = (float)yIndex * spriteSize;
        float maxV = minV + spriteSize;
        poseStack.m_85836_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        buffer.m_85982_(matrix, vertexPos[0].m_122239_(), vertexPos[0].m_122260_(), vertexPos[0].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(minU, maxV).m_5752_();
        buffer.m_85982_(matrix, vertexPos[1].m_122239_(), vertexPos[1].m_122260_(), vertexPos[1].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(maxU, maxV).m_5752_();
        buffer.m_85982_(matrix, vertexPos[2].m_122239_(), vertexPos[2].m_122260_(), vertexPos[2].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(maxU, minV).m_5752_();
        buffer.m_85982_(matrix, vertexPos[3].m_122239_(), vertexPos[3].m_122260_(), vertexPos[3].m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_7421_(minU, minV).m_5752_();
        poseStack.m_85849_();
    }
}

