/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArraySet;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.to_server.PacketQIOFillCraftingWindow;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QIOCraftingTransferHandler<CONTAINER extends QIOItemViewerContainer>
implements IRecipeTransferHandler<CONTAINER, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final Class<CONTAINER> containerClass;
    private final Function<HashedItem, String> recipeUUIDFunction;

    public QIOCraftingTransferHandler(IRecipeTransferHandlerHelper handlerHelper, IStackHelper stackHelper, Class<CONTAINER> containerClass) {
        this.handlerHelper = handlerHelper;
        this.containerClass = containerClass;
        this.recipeUUIDFunction = hashed -> stackHelper.getUniqueIdentifierForStack(hashed.getInternalStack(), UidContext.Recipe);
    }

    public Class<CONTAINER> getContainerClass() {
        return this.containerClass;
    }

    public Optional<MenuType<CONTAINER>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(CONTAINER container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        record TrackedIngredients(IRecipeSlotView view, Set<HashedItem> representations) {
        }
        List slotViews;
        int maxInputCount;
        byte selectedCraftingGrid = ((QIOItemViewerContainer)container).getSelectedCraftingGrid();
        if (selectedCraftingGrid == -1) {
            return this.handlerHelper.createInternalError();
        }
        QIOCraftingWindow craftingWindow = ((QIOItemViewerContainer)container).getCraftingWindow(selectedCraftingGrid);
        byte nonEmptyCraftingSlots = 0;
        if (!doTransfer) {
            CraftingContainer dummy = MekanismUtils.getDummyCraftingInv();
            for (int slot = 0; slot < 9; ++slot) {
                CraftingWindowInventorySlot inputSlot = craftingWindow.getInputSlot(slot);
                if (inputSlot.isEmpty()) continue;
                dummy.m_6836_(slot, StackUtils.size(inputSlot.getStack(), 1));
                nonEmptyCraftingSlots = (byte)(nonEmptyCraftingSlots + 1);
            }
            if (recipe.m_5818_((Container)dummy, player.f_19853_)) {
                return null;
            }
        }
        if ((maxInputCount = (slotViews = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT)).size()) > 9) {
            Mekanism.logger.warn("Error evaluating recipe transfer handler for recipe: {}, had more than 9 inputs: {}", (Object)recipe.m_6423_(), (Object)maxInputCount);
            return this.handlerHelper.createInternalError();
        }
        int inputCount = 0;
        Byte2ObjectArrayMap hashedIngredients = new Byte2ObjectArrayMap(maxInputCount);
        for (int index = 0; index < maxInputCount; ++index) {
            IRecipeSlotView slotView = (IRecipeSlotView)slotViews.get(index);
            List validIngredients = slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList();
            if (validIngredients.isEmpty()) continue;
            ++inputCount;
            ObjectIterator representations = new LinkedHashSet(validIngredients.size());
            ItemStack displayed = slotView.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.f_41583_);
            if (!displayed.m_41619_()) {
                representations.add(HashedItem.raw(displayed));
            }
            for (ItemStack validIngredient : validIngredients) {
                if (validIngredient.m_41619_()) continue;
                representations.add(HashedItem.raw(validIngredient));
            }
            hashedIngredients.put((byte)index, (Object)new TrackedIngredients(slotView, (Set<HashedItem>)representations));
        }
        QIOCraftingTransferHelper qioTransferHelper = ((QIOItemViewerContainer)container).getTransferHelper(player, craftingWindow);
        if (qioTransferHelper.isInvalid()) {
            Mekanism.logger.warn("Error initializing QIO transfer handler for crafting window: {}", (Object)selectedCraftingGrid);
            return this.handlerHelper.createInternalError();
        }
        HashMap<HashedItem, ByteList> matchedItems = new HashMap<HashedItem, ByteList>(inputCount);
        ByteArraySet missingSlots = new ByteArraySet(inputCount);
        for (Object entry : hashedIngredients.byte2ObjectEntrySet()) {
            boolean bl = false;
            for (HashedItem validInput : ((TrackedIngredients)entry.getValue()).representations()) {
                QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(validInput);
                if (source == null || !source.hasMoreRemaining()) continue;
                source.matchFound();
                bl = true;
                matchedItems.computeIfAbsent(validInput, item -> new ByteArrayList()).add(entry.getByteKey());
                break;
            }
            if (bl) continue;
            missingSlots.add(entry.getByteKey());
        }
        if (!missingSlots.isEmpty()) {
            HashMap<HashedItem, String> cachedIngredientUUIDs = new HashMap<HashedItem, String>();
            for (Map.Entry entry : qioTransferHelper.reverseLookup.entrySet()) {
                QIOCraftingTransferHelper.HashedItemSource source = (QIOCraftingTransferHelper.HashedItemSource)entry.getValue();
                if (!source.hasMoreRemaining()) continue;
                HashedItem storedHashedItem = (HashedItem)entry.getKey();
                Item storedItemType = storedHashedItem.getItem();
                String storedItemUUID = null;
                ByteIterator missingIterator = missingSlots.iterator();
                while (missingIterator.hasNext()) {
                    byte index = missingIterator.nextByte();
                    for (HashedItem validIngredient : ((TrackedIngredients)hashedIngredients.get(index)).representations()) {
                        String ingredientUUID;
                        if (storedItemType != validIngredient.getItem()) continue;
                        if (storedItemUUID == null) {
                            storedItemUUID = this.recipeUUIDFunction.apply(storedHashedItem);
                        }
                        if (!storedItemUUID.equals(ingredientUUID = cachedIngredientUUIDs.computeIfAbsent(validIngredient, this.recipeUUIDFunction))) continue;
                        source.matchFound();
                        missingIterator.remove();
                        matchedItems.computeIfAbsent(storedHashedItem, item -> new ByteArrayList()).add(index);
                        break;
                    }
                    if (source.hasMoreRemaining()) continue;
                    break;
                }
                if (!missingSlots.isEmpty()) continue;
                break;
            }
            if (!missingSlots.isEmpty()) {
                List<IRecipeSlotView> missing = missingSlots.intStream().mapToObj(arg_0 -> QIOCraftingTransferHandler.lambda$transferRecipe$3((Byte2ObjectMap)hashedIngredients, arg_0)).toList();
                return this.handlerHelper.createUserErrorForMissingSlots((Component)MekanismLang.JEI_MISSING_ITEMS.translate(new Object[0]), missing);
            }
        }
        if (doTransfer || nonEmptyCraftingSlots > 0 && nonEmptyCraftingSlots >= qioTransferHelper.getEmptyInventorySlots()) {
            int toTransfer;
            if (maxTransfer) {
                long maxToTransfer = Long.MAX_VALUE;
                for (Map.Entry entry : matchedItems.entrySet()) {
                    HashedItem hashedItem = (HashedItem)entry.getKey();
                    QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(hashedItem);
                    if (source == null) {
                        return this.invalidSource(hashedItem);
                    }
                    int maxStack = hashedItem.getMaxStackSize();
                    long max = maxStack == 1 ? maxToTransfer : Math.min(maxToTransfer, (long)maxStack);
                    maxToTransfer = Math.min(max, source.getAvailable() / (long)((ByteList)entry.getValue()).size());
                }
                toTransfer = MathUtils.clampToInt(maxToTransfer);
            } else {
                toTransfer = 1;
            }
            QIOFrequency frequency = ((QIOItemViewerContainer)container).getFrequency();
            Byte2ObjectArrayMap byte2ObjectArrayMap = new Byte2ObjectArrayMap(inputCount);
            HashMap<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> shuffleLookup = frequency == null ? Collections.emptyMap() : new HashMap<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>>(inputCount);
            for (Map.Entry entry : matchedItems.entrySet()) {
                HashedItem hashedItem = (HashedItem)entry.getKey();
                QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(hashedItem);
                if (source == null) {
                    return this.invalidSource(hashedItem);
                }
                int transferAmount = Math.min(toTransfer, hashedItem.getMaxStackSize());
                ByteListIterator byteListIterator = ((ByteList)entry.getValue()).iterator();
                while (byteListIterator.hasNext()) {
                    byte slot = (Byte)byteListIterator.next();
                    List<QIOCraftingTransferHelper.SingularHashedItemSource> actualSources = source.use(transferAmount);
                    if (actualSources.isEmpty()) {
                        return this.invalidSource(hashedItem);
                    }
                    byte2ObjectArrayMap.put(slot, actualSources);
                    if (frequency == null) continue;
                    int elements = ((ByteList)entry.getValue()).size();
                    if (elements == 1) {
                        shuffleLookup.put(source, Collections.singletonList(actualSources));
                        continue;
                    }
                    shuffleLookup.computeIfAbsent(source, s -> new ArrayList(elements)).add(actualSources);
                }
            }
            if (!QIOCraftingTransferHandler.hasRoomToShuffle(qioTransferHelper, frequency, craftingWindow, ((MekanismContainer)container).getHotBarSlots(), ((MekanismContainer)container).getMainInventorySlots(), shuffleLookup)) {
                return this.handlerHelper.createUserErrorWithTooltip((Component)MekanismLang.JEI_INVENTORY_FULL.translate(new Object[0]));
            }
            if (doTransfer) {
                Mekanism.packetHandler().sendToServer(new PacketQIOFillCraftingWindow(recipe.m_6423_(), maxTransfer, (Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>>)byte2ObjectArrayMap));
            }
        }
        return null;
    }

    private IRecipeTransferError invalidSource(@NotNull HashedItem type) {
        Mekanism.logger.warn("Error finding source for: {} with nbt: {}. This should not be possible.", (Object)type.getItem(), (Object)type.getInternalTag());
        return this.handlerHelper.createInternalError();
    }

    private static boolean hasRoomToShuffle(final QIOCraftingTransferHelper qioTransferHelper, @Nullable QIOFrequency frequency, QIOCraftingWindow craftingWindow, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots, Map<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> shuffleLookup) {
        Object2IntArrayMap leftOverInput = new Object2IntArrayMap(9);
        for (byte slotIndex = 0; slotIndex < 9; slotIndex = (byte)((byte)(slotIndex + 1))) {
            CraftingWindowInventorySlot slot = craftingWindow.getInputSlot(slotIndex);
            if (slot.isEmpty()) continue;
            HashedItem type = HashedItem.raw(slot.getStack());
            QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(type);
            if (source == null) {
                return false;
            }
            int remaining = source.getSlotRemaining(slotIndex);
            if (remaining <= 0) continue;
            leftOverInput.mergeInt((Object)type, remaining, Integer::sum);
        }
        if (!leftOverInput.isEmpty()) {
            QIOCraftingTransferHelper.BaseSimulatedInventory simulatedInventory = new QIOCraftingTransferHelper.BaseSimulatedInventory(hotBarSlots, mainInventorySlots){

                @Override
                protected int getRemaining(int slot, ItemStack currentStored) {
                    QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(HashedItem.raw(currentStored));
                    if (source == null) {
                        return currentStored.m_41613_();
                    }
                    return source.getSlotRemaining((byte)(slot + 9));
                }
            };
            Object2IntMap<HashedItem> stillLeftOver = simulatedInventory.shuffleInputs((Object2IntMap<HashedItem>)leftOverInput, frequency != null);
            if (stillLeftOver == null) {
                return false;
            }
            if (!stillLeftOver.isEmpty() && frequency != null) {
                QIOCraftingTransferHelper.HashedItemSource source;
                int availableItemTypes = frequency.getTotalItemTypeCapacity() - frequency.getTotalItemTypes(true);
                long availableItemSpace = frequency.getTotalItemCountCapacity() - frequency.getTotalItemCount();
                Object2BooleanArrayMap usedQIOSource = new Object2BooleanArrayMap(shuffleLookup.size());
                for (Map.Entry<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> entry : shuffleLookup.entrySet()) {
                    source = entry.getKey();
                    boolean usedQIO = false;
                    for (List<QIOCraftingTransferHelper.SingularHashedItemSource> usedSources : entry.getValue()) {
                        for (QIOCraftingTransferHelper.SingularHashedItemSource usedSource : usedSources) {
                            UUID qioSource = usedSource.getQioSource();
                            if (qioSource == null) continue;
                            availableItemSpace += (long)usedSource.getUsed();
                            if (source.getQIORemaining(qioSource) != 0L) continue;
                            ++availableItemTypes;
                            usedQIO = true;
                        }
                    }
                    usedQIOSource.put((Object)source, usedQIO);
                }
                for (Object2IntMap.Entry entry : stillLeftOver.object2IntEntrySet()) {
                    if ((availableItemSpace -= (long)entry.getIntValue()) <= 0L) {
                        return false;
                    }
                    source = qioTransferHelper.getSource((HashedItem)entry.getKey());
                    if (source == null) {
                        return false;
                    }
                    if (!(source.hasQIOSources() ? usedQIOSource.containsKey((Object)source) && usedQIOSource.getBoolean((Object)source) && --availableItemTypes <= 0 : --availableItemTypes <= 0)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ IRecipeSlotView lambda$transferRecipe$3(Byte2ObjectMap hashedIngredients, int slot) {
        return ((TrackedIngredients)hashedIngredients.get((byte)slot)).view();
    }
}

