/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MovableFilterButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.gui.element.tab.GuiQIOFrequencyTab;
import mekanism.client.gui.element.window.filter.qio.GuiQIOItemStackFilter;
import mekanism.client.gui.element.window.filter.qio.GuiQIOModIDFilter;
import mekanism.client.gui.element.window.filter.qio.GuiQIOTagFilter;
import mekanism.client.gui.qio.GuiQIOFilerSelect;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiQIOFilterHandler<TILE extends TileEntityQIOFilterHandler>
extends GuiMekanismTile<TILE, MekanismTileContainer<TILE>> {
    private static final int FILTER_COUNT = 3;
    private GuiScrollBar scrollBar;

    static Supplier<List<Component>> getFrequencyText(IQIOFrequencyHolder holder) {
        return () -> {
            QIOFrequency freq = holder.getQIOFrequency();
            if (freq == null) {
                return List.of(MekanismLang.NO_FREQUENCY.translate(new Object[0]));
            }
            return List.of(MekanismLang.FREQUENCY.translate(freq.getKey()));
        };
    }

    static Supplier<List<Component>> getFrequencyTooltip(IQIOFrequencyHolder holder) {
        return () -> {
            QIOFrequency freq = holder.getQIOFrequency();
            if (freq == null) {
                return List.of();
            }
            return List.of(MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemCount()), TextUtils.format(freq.getTotalItemCountCapacity())), MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemTypes(true)), TextUtils.format(freq.getTotalItemTypeCapacity())));
        };
    }

    public GuiQIOFilterHandler(MekanismTileContainer<TILE> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.f_97727_ += 74;
        this.f_97731_ = this.f_97727_ - 94;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiQIOFrequencyTab((IGuiWrapper)this, this.tile));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 9, 16, this.f_97726_ - 18, 12, GuiQIOFilterHandler.getFrequencyText((IQIOFrequencyHolder)((Object)this.tile))).tooltip(GuiQIOFilterHandler.getFrequencyTooltip((IQIOFrequencyHolder)((Object)this.tile))));
        this.addRenderableWidget(new GuiElementHolder(this, 9, 30, 144, 68));
        this.addRenderableWidget(new GuiElementHolder(this, 9, 98, 144, 22));
        this.addRenderableWidget(new TranslationButton(this, 10, 99, 142, 20, MekanismLang.BUTTON_NEW_FILTER, () -> this.addWindow(new GuiQIOFilerSelect(this, (TileEntityQIOFilterHandler)this.tile))));
        FilterManager filterManager = ((TileEntityQIOFilterHandler)this.tile).getFilterManager();
        this.scrollBar = this.addRenderableWidget(new GuiScrollBar((IGuiWrapper)this, 153, 30, 90, ((SortableFilterManager)filterManager)::count, () -> 3));
        for (int i = 0; i < 3; ++i) {
            this.addRenderableWidget(new MovableFilterButton(this, 10, 31 + i * 22, 142, 22, i, this.scrollBar::getCurrentSelection, filterManager, index -> {
                if (index > 0) {
                    Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_UP, (BlockEntity)this.tile, index));
                }
            }, arg_0 -> this.lambda$addGuiElements$5((SortableFilterManager)filterManager, arg_0), this::onClick, index -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.TOGGLE_FILTER_STATE, (BlockEntity)this.tile, index)), filter -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                if (filter != null) {
                    if (filter instanceof IItemStackFilter) {
                        IItemStackFilter itemFilter = (IItemStackFilter)filter;
                        list.add(itemFilter.getItemStack());
                    } else if (filter instanceof ITagFilter) {
                        ITagFilter tagFilter = (ITagFilter)filter;
                        String name = tagFilter.getTagName();
                        if (name != null && !name.isEmpty()) {
                            list.addAll(TagCache.getItemTagStacks(tagFilter.getTagName()));
                        }
                    } else if (filter instanceof IModIDFilter) {
                        IModIDFilter modIDFilter = (IModIDFilter)filter;
                        list.addAll(TagCache.getItemModIDStacks(modIDFilter.getModID()));
                    }
                }
                return list;
            }));
        }
    }

    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiQIOItemStackFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiQIOTagFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOTagFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiQIOModIDFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOModIDFilter)filter));
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta) || this.scrollBar.adjustScroll(delta);
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private /* synthetic */ void lambda$addGuiElements$5(SortableFilterManager filterManager, int index) {
        if (index < filterManager.count() - 1) {
            Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_DOWN, (BlockEntity)this.tile, index));
        }
    }
}

