/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.filter.IFilterableTile;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileFilterGuiOpenPacket
extends PacketBase
implements IPacketServer {
    public static byte TILE = 0;
    public static byte FILTER = 1;
    protected BlockPos pos;
    protected byte mode;

    public TileFilterGuiOpenPacket() {
        super(20, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IFilterableTile) {
            IFilterableTile filterable = (IFilterableTile)tile;
            if (this.mode == TILE) {
                filterable.openGui(player);
            } else if (this.mode == FILTER) {
                filterable.openFilterGui(player);
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.mode = buf.readByte();
    }

    public static void openFilterGui(IFilterableTile tile) {
        TileFilterGuiOpenPacket.sendToServer(tile, FILTER);
    }

    public static void openTileGui(IFilterableTile tile) {
        TileFilterGuiOpenPacket.sendToServer(tile, TILE);
    }

    protected static void sendToServer(IFilterableTile tile, byte mode) {
        TileFilterGuiOpenPacket packet = new TileFilterGuiOpenPacket();
        packet.pos = tile.pos();
        packet.mode = mode;
        packet.sendToServer();
    }
}

