/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import cofh.core.fluid.ExperienceFluid;
import cofh.core.fluid.HoneyFluid;
import cofh.core.fluid.PotionFluid;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.tags.FluidTagsCoFH;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class CoreFluids {
    public static Supplier<ForgeFlowingFluid> EXPERIENCE_FLUID;
    public static Supplier<ForgeFlowingFluid> HONEY_FLUID;
    public static Supplier<ForgeFlowingFluid> POTION_FLUID;

    private CoreFluids() {
    }

    public static void register() {
        EXPERIENCE_FLUID = ExperienceFluid.create().still();
        HONEY_FLUID = HoneyFluid.create().still();
        POTION_FLUID = PotionFluid.create().still();
    }

    public static void setup() {
        FluidHelper.BOTTLE_DRAIN_MAP.put(Items.f_42589_, stack -> PotionFluid.getPotionFluidFromItem(250, stack));
        FluidHelper.BOTTLE_DRAIN_MAP.put(Items.f_42787_, stack -> new FluidStack((Fluid)HONEY_FLUID.get(), 250));
        FluidHelper.BOTTLE_DRAIN_MAP.put(Items.f_42612_, stack -> new FluidStack((Fluid)EXPERIENCE_FLUID.get(), 250));
        FluidHelper.BOTTLE_FILL_MAP.put(fluid -> fluid.getFluid() == Fluids.f_76193_ || FluidHelper.hasPotionTag(fluid), PotionFluid::getItemFromPotionFluid);
        FluidHelper.BOTTLE_FILL_MAP.put(fluid -> fluid.getFluid().m_205067_(FluidTagsCoFH.HONEY), fluid -> new ItemStack((ItemLike)Items.f_42787_));
        FluidHelper.BOTTLE_FILL_MAP.put(fluid -> fluid.getFluid().m_205067_(FluidTagsCoFH.EXPERIENCE), fluid -> new ItemStack((ItemLike)Items.f_42612_));
    }
}

