/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.util.RandomIntRange;

public class ChancedEffectInstance {
    protected final float chance;
    protected final MobEffect effect;
    protected final RandomIntRange amp;
    protected final boolean ambient;
    protected final boolean visible;

    public ChancedEffectInstance(float chance, MobEffect effect, RandomIntRange amp, boolean ambient, boolean visible) {
        this.chance = chance;
        this.effect = effect;
        this.amp = amp;
        this.ambient = ambient;
        this.visible = visible;
    }

    public float getChance() {
        return this.chance;
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public MobEffectInstance createInstance(RandomSource rand, int duration) {
        return new MobEffectInstance(this.effect, duration, this.amp.generateInt(rand), this.ambient, this.visible);
    }

    public static class Deserializer
    implements JsonDeserializer<ChancedEffectInstance> {
        public ChancedEffectInstance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            boolean visible;
            JsonObject obj = json.getAsJsonObject();
            float chance = obj.get("chance").getAsFloat();
            String _effect = obj.get("effect").getAsString();
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(_effect));
            if (effect == null) {
                throw new JsonParseException("Attempted to construct a ChancedEffectInstance with invalid effect: " + _effect);
            }
            boolean ambient = obj.has("ambient") ? obj.get("ambient").getAsBoolean() : true;
            boolean bl = visible = obj.has("visible") ? obj.get("visible").getAsBoolean() : false;
            if (obj.has("amplifier")) {
                JsonObject range = obj.get("amplifier").getAsJsonObject();
                int min = range.get("min").getAsInt();
                int max = range.get("max").getAsInt();
                return new ChancedEffectInstance(chance, effect, new RandomIntRange(min, max), ambient, visible);
            }
            return new ChancedEffectInstance(chance, effect, RandomIntRange.ZERO, ambient, visible);
        }
    }
}

