/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.SinglePoolElementAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.PieceEntry;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PieceInHorizontalDirectionCondition
extends StructureCondition {
    private static final ResourceLocation ALL = new ResourceLocation("yungsapi", "all");
    public static final Codec<PieceInHorizontalDirectionCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.listOf().optionalFieldOf("pieces", new ArrayList()).forGetter(conditon -> conditon.matchPieces), (App)Codec.INT.fieldOf("range").forGetter(conditon -> conditon.range), (App)Rotation.f_221983_.fieldOf("rotation").forGetter(conditon -> conditon.rotation)).apply((Applicative)builder, PieceInHorizontalDirectionCondition::new));
    private final List<ResourceLocation> matchPieces;
    private final Integer range;
    private final Rotation rotation;

    public PieceInHorizontalDirectionCondition(List<ResourceLocation> pieces, int range, Rotation rotation) {
        this.matchPieces = pieces;
        this.range = range;
        this.rotation = rotation;
        if (this.matchPieces.isEmpty()) {
            this.matchPieces.add(ALL);
        }
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.PIECE_IN_HORIZONTAL_DIRECTION;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        StructureTemplateManager templateManager = ctx.structureTemplateManager();
        List<PieceEntry> pieces = ctx.pieces();
        Rotation pieceRotation = ctx.rotation();
        PieceEntry pieceEntry = ctx.pieceEntry();
        if (templateManager == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'structureTemplateManager' for piece_in_horizontal_direction condition!");
        }
        if (pieces == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieces' for piece_in_horizontal_direction condition!");
        }
        if (this.rotation == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'rotation' for piece_in_horizontal_direction condition!");
        }
        if (pieceEntry == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieceEntry' for piece_in_horizontal_direction condition!");
        }
        if (templateManager == null || pieces == null || this.rotation == null || pieceEntry == null) {
            return false;
        }
        PoolElementStructurePiece piece = pieceEntry.getPiece();
        Rotation searchRotation = pieceRotation.m_55952_(this.rotation);
        int negX = 0;
        int negZ = 0;
        int posX = 0;
        int posZ = 0;
        switch (searchRotation) {
            case NONE: {
                negZ = this.range;
                break;
            }
            case CLOCKWISE_90: {
                posX = this.range;
                break;
            }
            case CLOCKWISE_180: {
                posZ = this.range;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                negX = this.range;
            }
        }
        BoundingBox searchBox = new BoundingBox(piece.m_73547_().m_162395_() - negX, piece.m_73547_().m_162396_(), piece.m_73547_().m_162398_() - negZ, piece.m_73547_().m_162399_() + posX, piece.m_73547_().m_162400_(), piece.m_73547_().m_162401_() + posZ);
        for (PieceEntry otherPieceEntry : pieces) {
            PoolElementStructurePiece otherPiece = otherPieceEntry.getPiece();
            StructurePoolElement structurePoolElement = otherPiece.m_209918_();
            if (!(structurePoolElement instanceof SinglePoolElement)) continue;
            SinglePoolElement singlePoolElement = (SinglePoolElement)structurePoolElement;
            if (otherPiece.m_73547_().equals((Object)piece.m_73547_())) continue;
            StructureTemplate otherStructureTemplate = ((SinglePoolElementAccessor)singlePoolElement).callGetTemplate(templateManager);
            for (ResourceLocation matchPieceId : this.matchPieces) {
                StructureTemplate structureTemplate = templateManager.m_230359_(matchPieceId);
                if (otherStructureTemplate != structureTemplate && !matchPieceId.equals((Object)ALL) || !otherPiece.m_73547_().m_71049_(searchBox) || otherPiece.m_73547_().m_71049_(piece.m_73547_())) continue;
                return true;
            }
        }
        return false;
    }
}

